"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SECURITY_TO = exports.SECURITY_RULE_STATUS = exports.SECURITY_RULE_ID = exports.SECURITY_QUERY_SPAN_S = exports.SECURITY_PARAMS = exports.SECURITY_NUM_RANGE_TUPLES = exports.SECURITY_NUM_INDICES_MATCHING_PATTERN = exports.SECURITY_NUM_IGNORE_FIELDS_STANDARD = exports.SECURITY_NUM_IGNORE_FIELDS_REGEX = exports.SECURITY_NUM_EXCEPTION_ITEMS = exports.SECURITY_NUM_ALERTS_CREATED = exports.SECURITY_MERGE_STRATEGY = exports.SECURITY_MAX_SIGNALS = exports.SECURITY_INPUT_INDEX = exports.SECURITY_IMMUTABLE = exports.SECURITY_FROM = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Schema field names and descriptions for APM labels set by security rule executors

/**
 * Copy of `from` value from rule params.
 */
const SECURITY_FROM = exports.SECURITY_FROM = 'security_from';

/**
 * Copy of `to` value from rule params.
 */
const SECURITY_TO = exports.SECURITY_TO = 'security_to';

/**
 * Difference between `from` and `to`, in seconds.
 */
const SECURITY_QUERY_SPAN_S = exports.SECURITY_QUERY_SPAN_S = 'security_query_span_s';
/**
 * Copy of `immutable` value from rule params.
 */
const SECURITY_IMMUTABLE = exports.SECURITY_IMMUTABLE = 'security_immutable';

/**
 * Copy of `max_signals` value from rule params.
 */
const SECURITY_MAX_SIGNALS = exports.SECURITY_MAX_SIGNALS = 'security_max_signals';

/**
 * Copy of `rule_id` value from rule params.
 */
const SECURITY_RULE_ID = exports.SECURITY_RULE_ID = 'security_rule_id';

/**
 * Rule status.
 */
const SECURITY_RULE_STATUS = exports.SECURITY_RULE_STATUS = 'security_rule_status';

// Schema field names and descriptions for APM custom context set by security rule executors

/**
 * Copy of all rule parameters.
 */
const SECURITY_PARAMS = exports.SECURITY_PARAMS = 'security_params';

/**
 * Index patterns queried by the rule (if applicable to rule type). Either a copy of the `index` rule param or the
 * index patterns loaded from the rule's data view.
 */
const SECURITY_INPUT_INDEX = exports.SECURITY_INPUT_INDEX = 'security_input_index';

/**
 * Number of separate time intervals the rule will query. Rules query 1 interval if no gaps are detected, or more than
 * 1 if gaps are detected.
 */
const SECURITY_NUM_RANGE_TUPLES = exports.SECURITY_NUM_RANGE_TUPLES = 'security_num_range_tuples';

/**
 * Number of "ignore fields" - fields that are stripped from `fields` part of search response before merging `fields` into _source. "Standard"
 * means field names that are normal strings.
 */
const SECURITY_NUM_IGNORE_FIELDS_STANDARD = exports.SECURITY_NUM_IGNORE_FIELDS_STANDARD = 'security_ignore_fields_num_standard';

/**
 * Number of "ignore fields" regular expressions
 */
const SECURITY_NUM_IGNORE_FIELDS_REGEX = exports.SECURITY_NUM_IGNORE_FIELDS_REGEX = 'security_ignore_fields_num_regex';

/**
 * Number of exception items.
 */
const SECURITY_NUM_EXCEPTION_ITEMS = exports.SECURITY_NUM_EXCEPTION_ITEMS = 'security_exceptions_num_total';

/**
 * Merge strategy used by the rule to combine `_source` and `fields` when building alerts.
 */
const SECURITY_MERGE_STRATEGY = exports.SECURITY_MERGE_STRATEGY = 'security_merge_strategy';

/**
 * Number of alerts generated by the rule execution.
 */
const SECURITY_NUM_ALERTS_CREATED = exports.SECURITY_NUM_ALERTS_CREATED = 'security_num_alerts_created';

/**
 * Number of concrete indices matching index pattern.
 */
const SECURITY_NUM_INDICES_MATCHING_PATTERN = exports.SECURITY_NUM_INDICES_MATCHING_PATTERN = 'security_num_indices_matching_pattern';