"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UnifiedQueryRuleParams = exports.TypeSpecificRuleParams = exports.ThresholdSpecificRuleParams = exports.ThresholdRuleParams = exports.ThreatSpecificRuleParams = exports.ThreatRuleParams = exports.SavedQuerySpecificRuleParams = exports.SavedQueryRuleParams = exports.RuleSourceCamelCased = exports.RuleParams = exports.QuerySpecificRuleParams = exports.QueryRuleParams = exports.NewTermsSpecificRuleParams = exports.NewTermsRuleParams = exports.MachineLearningSpecificRuleParams = exports.MachineLearningRuleParams = exports.LegacyInvestigationFields = exports.InvestigationFieldsCombined = exports.InternalRuleSourceCamelCased = exports.ExternalRuleSourceCamelCased = exports.EsqlSpecificRuleParams = exports.EsqlRuleParams = exports.EqlSpecificRuleParams = exports.EqlRuleParams = exports.BaseRuleParams = void 0;
var z = _interopRequireWildcard(require("@kbn/zod"));
var _detection_engine = require("../../../../../common/api/detection_engine");
var _rule_schema = require("../../../../../common/api/detection_engine/model/rule_schema");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// 8.10.x is mapped as an array of strings

const LegacyInvestigationFields = exports.LegacyInvestigationFields = z.array(z.string());

/*
 * In ESS 8.10.x "investigation_fields" are mapped as string[].
 * For 8.11+ logic is added on read in our endpoints to migrate
 * the data over to it's intended type of { field_names: string[] }.
 * The SO rule type will continue to support both types until we deprecate,
 * but APIs will only support intended object format.
 * See PR 169061
 */

const InvestigationFieldsCombined = exports.InvestigationFieldsCombined = z.union([_rule_schema.InvestigationFields, LegacyInvestigationFields]);
const ExternalRuleSourceCamelCased = exports.ExternalRuleSourceCamelCased = z.object({
  type: z.literal('external'),
  isCustomized: _rule_schema.IsExternalRuleCustomized,
  customizedFields: z.array(z.object({
    fieldName: z.string()
  })).optional(),
  hasBaseVersion: z.boolean().optional()
});
const InternalRuleSourceCamelCased = exports.InternalRuleSourceCamelCased = z.object({
  type: z.literal('internal')
});

/**
 * This is the same type as RuleSource, but with the keys in camelCase. Intended
 * for internal use only (not for API responses).
 */

const RuleSourceCamelCased = exports.RuleSourceCamelCased = z.discriminatedUnion('type', [ExternalRuleSourceCamelCased, InternalRuleSourceCamelCased]);

// Conversion to an interface has to be disabled for the entire file; otherwise,
// the resulting union would not be assignable to Alerting's RuleParams due to a
// TypeScript bug: https://github.com/microsoft/TypeScript/issues/15300

const BaseRuleParams = exports.BaseRuleParams = z.object({
  author: _rule_schema.RuleAuthorArray,
  buildingBlockType: _rule_schema.BuildingBlockType.optional(),
  description: _rule_schema.RuleDescription,
  namespace: _rule_schema.AlertsIndexNamespace.optional(),
  note: _rule_schema.InvestigationGuide.optional(),
  falsePositives: _rule_schema.RuleFalsePositiveArray,
  from: _rule_schema.RuleIntervalFrom,
  ruleId: _rule_schema.RuleSignatureId,
  investigationFields: InvestigationFieldsCombined.optional(),
  immutable: _rule_schema.IsRuleImmutable,
  ruleSource: RuleSourceCamelCased.optional(),
  license: _rule_schema.RuleLicense.optional(),
  outputIndex: _rule_schema.AlertsIndex,
  timelineId: _rule_schema.TimelineTemplateId.optional(),
  timelineTitle: _rule_schema.TimelineTemplateTitle.optional(),
  meta: _rule_schema.RuleMetadata.optional(),
  maxSignals: _rule_schema.MaxSignals,
  riskScore: _rule_schema.RiskScore,
  riskScoreMapping: _rule_schema.RiskScoreMapping,
  ruleNameOverride: _rule_schema.RuleNameOverride.optional(),
  severity: _rule_schema.Severity,
  severityMapping: _rule_schema.SeverityMapping,
  timestampOverride: _rule_schema.TimestampOverride.optional(),
  timestampOverrideFallbackDisabled: _rule_schema.TimestampOverrideFallbackDisabled.optional(),
  threat: _rule_schema.ThreatArray,
  to: _rule_schema.RuleIntervalTo,
  references: _rule_schema.RuleReferenceArray,
  version: _rule_schema.RuleVersion,
  exceptionsList: _rule_schema.RuleExceptionList.array(),
  relatedIntegrations: _rule_schema.RelatedIntegrationArray.optional(),
  requiredFields: _rule_schema.RequiredFieldArray.optional(),
  setup: _rule_schema.SetupGuide.optional(),
  responseActions: z.array(_detection_engine.RuleResponseAction).optional()
});
const EqlSpecificRuleParams = exports.EqlSpecificRuleParams = z.object({
  type: z.literal('eql'),
  language: z.literal('eql'),
  index: _rule_schema.IndexPatternArray.optional(),
  dataViewId: _rule_schema.DataViewId.optional(),
  query: _rule_schema.RuleQuery,
  filters: _rule_schema.RuleFilterArray.optional(),
  eventCategoryOverride: _rule_schema.EventCategoryOverride.optional(),
  timestampField: _rule_schema.TimestampField.optional(),
  tiebreakerField: _rule_schema.TiebreakerField.optional(),
  alertSuppression: _rule_schema.AlertSuppressionCamel.optional()
});
const EqlRuleParams = exports.EqlRuleParams = z.intersection(BaseRuleParams, EqlSpecificRuleParams);
const EsqlSpecificRuleParams = exports.EsqlSpecificRuleParams = z.object({
  type: z.literal('esql'),
  language: z.literal('esql'),
  query: _rule_schema.RuleQuery,
  alertSuppression: _rule_schema.AlertSuppressionCamel.optional()
});
const EsqlRuleParams = exports.EsqlRuleParams = z.intersection(BaseRuleParams, EsqlSpecificRuleParams);
const ThreatSpecificRuleParams = exports.ThreatSpecificRuleParams = z.object({
  type: z.literal('threat_match'),
  language: _rule_schema.KqlQueryLanguage,
  index: _rule_schema.IndexPatternArray.optional(),
  query: _rule_schema.RuleQuery,
  filters: _rule_schema.RuleFilterArray.optional(),
  savedId: _rule_schema.SavedQueryId.optional(),
  threatFilters: _rule_schema.RuleFilterArray.optional(),
  threatQuery: _rule_schema.ThreatQuery,
  threatMapping: _rule_schema.ThreatMapping,
  threatLanguage: _rule_schema.KqlQueryLanguage.optional(),
  threatIndex: _rule_schema.ThreatIndex,
  threatIndicatorPath: _rule_schema.ThreatIndicatorPath.optional(),
  concurrentSearches: _rule_schema.ConcurrentSearches.optional(),
  itemsPerSearch: _rule_schema.ItemsPerSearch.optional(),
  dataViewId: _rule_schema.DataViewId.optional(),
  alertSuppression: _rule_schema.AlertSuppressionCamel.optional()
});
const ThreatRuleParams = exports.ThreatRuleParams = z.intersection(BaseRuleParams, ThreatSpecificRuleParams);
const QuerySpecificRuleParams = exports.QuerySpecificRuleParams = z.object({
  type: z.literal('query'),
  language: _rule_schema.KqlQueryLanguage,
  index: _rule_schema.IndexPatternArray.optional(),
  query: _rule_schema.RuleQuery,
  filters: _rule_schema.RuleFilterArray.optional(),
  savedId: _rule_schema.SavedQueryId.optional(),
  dataViewId: _rule_schema.DataViewId.optional(),
  alertSuppression: _rule_schema.AlertSuppressionCamel.optional()
});
const QueryRuleParams = exports.QueryRuleParams = z.intersection(BaseRuleParams, QuerySpecificRuleParams);
const SavedQuerySpecificRuleParams = exports.SavedQuerySpecificRuleParams = z.object({
  type: z.literal('saved_query'),
  language: _rule_schema.KqlQueryLanguage,
  index: _rule_schema.IndexPatternArray.optional(),
  dataViewId: _rule_schema.DataViewId.optional(),
  query: _rule_schema.RuleQuery.optional(),
  filters: _rule_schema.RuleFilterArray.optional(),
  savedId: _rule_schema.SavedQueryId,
  alertSuppression: _rule_schema.AlertSuppressionCamel.optional()
});
const SavedQueryRuleParams = exports.SavedQueryRuleParams = z.intersection(BaseRuleParams, SavedQuerySpecificRuleParams);
const UnifiedQueryRuleParams = exports.UnifiedQueryRuleParams = z.intersection(BaseRuleParams, z.union([QuerySpecificRuleParams, SavedQuerySpecificRuleParams]));
const ThresholdSpecificRuleParams = exports.ThresholdSpecificRuleParams = z.object({
  type: z.literal('threshold'),
  language: _rule_schema.KqlQueryLanguage,
  index: _rule_schema.IndexPatternArray.optional(),
  query: _rule_schema.RuleQuery,
  filters: _rule_schema.RuleFilterArray.optional(),
  savedId: _rule_schema.SavedQueryId.optional(),
  threshold: _rule_schema.ThresholdNormalized,
  dataViewId: _rule_schema.DataViewId.optional(),
  alertSuppression: _rule_schema.ThresholdAlertSuppression.optional()
});
const ThresholdRuleParams = exports.ThresholdRuleParams = z.intersection(BaseRuleParams, ThresholdSpecificRuleParams);
const MachineLearningSpecificRuleParams = exports.MachineLearningSpecificRuleParams = z.object({
  type: z.literal('machine_learning'),
  anomalyThreshold: _rule_schema.AnomalyThreshold,
  machineLearningJobId: z.array(z.string()),
  alertSuppression: _rule_schema.AlertSuppressionCamel.optional()
});
const MachineLearningRuleParams = exports.MachineLearningRuleParams = z.intersection(BaseRuleParams, MachineLearningSpecificRuleParams);
const NewTermsSpecificRuleParams = exports.NewTermsSpecificRuleParams = z.object({
  type: z.literal('new_terms'),
  query: _rule_schema.RuleQuery,
  newTermsFields: _rule_schema.NewTermsFields,
  historyWindowStart: _rule_schema.HistoryWindowStart,
  index: _rule_schema.IndexPatternArray.optional(),
  filters: _rule_schema.RuleFilterArray.optional(),
  language: _rule_schema.KqlQueryLanguage,
  dataViewId: _rule_schema.DataViewId.optional(),
  alertSuppression: _rule_schema.AlertSuppressionCamel.optional()
});
const NewTermsRuleParams = exports.NewTermsRuleParams = z.intersection(BaseRuleParams, NewTermsSpecificRuleParams);
const TypeSpecificRuleParams = exports.TypeSpecificRuleParams = z.union([EqlSpecificRuleParams, EsqlSpecificRuleParams, ThreatSpecificRuleParams, QuerySpecificRuleParams, SavedQuerySpecificRuleParams, ThresholdSpecificRuleParams, MachineLearningSpecificRuleParams, NewTermsSpecificRuleParams]);
const RuleParams = exports.RuleParams = z.union([EqlRuleParams, EsqlRuleParams, ThreatRuleParams, QueryRuleParams, SavedQueryRuleParams, ThresholdRuleParams, MachineLearningRuleParams, NewTermsRuleParams]);