"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.handleScheduleBackfillResults = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const handleScheduleBackfillResults = ({
  results,
  rules
}) => {
  const errors = [];
  return results.reduce((acc, backfillResult) => {
    if ('error' in backfillResult) {
      var _rules$find, _ref, _backfillRule$name;
      const ruleName = (_rules$find = rules.find(rule => rule.id === backfillResult.error.rule.id)) === null || _rules$find === void 0 ? void 0 : _rules$find.name;
      const backfillError = backfillResult.error;
      const backfillRule = backfillError.rule;
      const error = {
        message: backfillError.message,
        status: backfillError.status,
        rule: {
          id: backfillRule.id,
          name: (_ref = (_backfillRule$name = backfillRule.name) !== null && _backfillRule$name !== void 0 ? _backfillRule$name : ruleName) !== null && _ref !== void 0 ? _ref : ''
        }
      };
      acc.errors.push(error);
    } else {
      const backfillRule = rules.find(rule => rule.id === backfillResult.rule.id);
      if (backfillRule) {
        acc.backfilled.push(backfillRule);
      }
    }
    return acc;
  }, {
    backfilled: [],
    errors
  });
};
exports.handleScheduleBackfillResults = handleScheduleBackfillResults;