"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseEntitySourceAggs = exports.getEntitySourceStats = void 0;
var _helper = require("../helper");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Parses aggregation buckets into a simplified list of entity stats.
 */
const parseEntitySourceAggs = response => {
  return response.buckets.map(bucket => ({
    entity_source: bucket.key,
    doc_count: bucket.doc_count,
    last_doc_timestamp: bucket.last_doc_timestamp.value_as_string
  }));
};

/**
 * Queries Elasticsearch for entity type stats, parses, and returns them.
 */
exports.parseEntitySourceAggs = parseEntitySourceAggs;
const getEntitySourceStats = async (esClient, logger) => {
  try {
    var _entitySourceStats$ag, _entitySourceStats$ag2, _entitySourceStats$ag3;
    const isIndexExists = await esClient.indices.exists({
      index: _helper.ENTITY_INDEX
    });
    if (!isIndexExists) {
      logger.debug(`Index ${_helper.ENTITY_INDEX} does not exist.`);
      return [];
    }
    const entitySourceStats = await esClient.search((0, _helper.getAggsQuery)('entity.source', 500));
    const buckets = (_entitySourceStats$ag = (_entitySourceStats$ag2 = entitySourceStats.aggregations) === null || _entitySourceStats$ag2 === void 0 ? void 0 : (_entitySourceStats$ag3 = _entitySourceStats$ag2.field_terms) === null || _entitySourceStats$ag3 === void 0 ? void 0 : _entitySourceStats$ag3.buckets) !== null && _entitySourceStats$ag !== void 0 ? _entitySourceStats$ag : [];
    return parseEntitySourceAggs({
      buckets
    });
  } catch (e) {
    logger.error(`Failed to get entity source stats: ${e instanceof Error ? e.message : String(e)}`);
    return [];
  }
};
exports.getEntitySourceStats = getEntitySourceStats;