"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.TimelineQueryTabEventsCountComponent = void 0;
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _common = require("@kbn/data-plugin/common");
var _eui = require("@elastic/eui");
var _unifiedDataTable = require("@kbn/unified-data-table");
var _use_selected_patterns = require("../../../../../data_view_manager/hooks/use_selected_patterns");
var _use_browser_fields = require("../../../../../data_view_manager/hooks/use_browser_fields");
var _use_data_view = require("../../../../../data_view_manager/hooks/use_data_view");
var _use_selector = require("../../../../../common/hooks/use_selector");
var _use_timeline_data_filters = require("../../../../containers/use_timeline_data_filters");
var _use_invalid_filter_query = require("../../../../../common/hooks/use_invalid_filter_query");
var _store = require("../../../../store");
var _containers = require("../../../../containers");
var _kibana = require("../../../../../common/lib/kibana");
var _kuery = require("../../../../../common/lib/kuery");
var _store2 = require("../../../../../common/store");
var _model = require("../../../../../sourcerer/store/model");
var _defaults = require("../../../../store/defaults");
var _containers2 = require("../../../../../sourcerer/containers");
var _helpers = require("../../../../../helpers");
var _use_timeline_columns = require("../shared/use_timeline_columns");
var _layout = require("../shared/layout");
var _use_experimental_features = require("../../../../../common/hooks/use_experimental_features");
var _constants = require("../../../../../data_view_manager/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/timeline/tabs/query/events_count.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/* eslint-disable complexity */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * TODO: This component is a pared down duplicate of the logic used in timeline/tabs/query/index.tsx
 * This is only done to support the events count badge that shows in the bottom bar of the application,
 * without needing to render the entire query tab, which is expensive to render at a significant enough fields count.
 * The long term solution is a centralized query either via RTK or useQuery, that both can read from, but that is out of scope
 * at this current time.
 */

const emptyFieldsList = [];
const TimelineQueryTabEventsCountComponent = ({
  timelineId
}) => {
  var _kqlQueryTimeline$exp, _kqlQueryTimeline$exp2, _kqlQueryTimeline$kin, _ref, _ref2;
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  const getTimeline = (0, _react.useMemo)(() => _store.timelineSelectors.getTimelineByIdSelector(), []);
  const getKqlQueryTimeline = (0, _react.useMemo)(() => _store.timelineSelectors.getKqlFilterKuerySelector(), []);
  const getInputsTimeline = (0, _react.useMemo)(() => _store2.inputsSelectors.getTimelineSelector(), []);
  const timeline = (0, _use_selector.useDeepEqualSelector)(state => {
    var _getTimeline;
    return (_getTimeline = getTimeline(state, timelineId)) !== null && _getTimeline !== void 0 ? _getTimeline : _defaults.timelineDefaults;
  });
  const input = (0, _use_selector.useDeepEqualSelector)(state => getInputsTimeline(state));
  const {
    timerange: {
      to: end,
      from: start,
      kind: timerangeKind
    } = {}
  } = input;
  const {
    columns,
    dataProviders,
    filters: currentTimelineFilters,
    kqlMode,
    sort,
    timelineType
  } = timeline;
  const kqlQueryTimeline = (0, _use_selector.useDeepEqualSelector)(state => getKqlQueryTimeline(state, timelineId));
  const filters = (0, _react.useMemo)(() => kqlMode === 'filter' ? currentTimelineFilters || [] : [], [currentTimelineFilters, kqlMode]);

  // return events on empty search
  const kqlQueryExpression = (0, _fp.isEmpty)(dataProviders) && (0, _fp.isEmpty)((_kqlQueryTimeline$exp = kqlQueryTimeline === null || kqlQueryTimeline === void 0 ? void 0 : kqlQueryTimeline.expression) !== null && _kqlQueryTimeline$exp !== void 0 ? _kqlQueryTimeline$exp : '') && timelineType === 'template' ? ' ' : (_kqlQueryTimeline$exp2 = kqlQueryTimeline === null || kqlQueryTimeline === void 0 ? void 0 : kqlQueryTimeline.expression) !== null && _kqlQueryTimeline$exp2 !== void 0 ? _kqlQueryTimeline$exp2 : '';
  const kqlQueryLanguage = (0, _fp.isEmpty)(dataProviders) && timelineType === 'template' ? 'kuery' : (_kqlQueryTimeline$kin = kqlQueryTimeline === null || kqlQueryTimeline === void 0 ? void 0 : kqlQueryTimeline.kind) !== null && _kqlQueryTimeline$kin !== void 0 ? _kqlQueryTimeline$kin : 'kuery';
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    browserFields: oldBrowserFields,
    dataViewId,
    loading: loadingSourcerer,
    // important to get selectedPatterns from useSourcererDataView
    // in order to include the exclude filters in the search that are not stored in the timeline
    selectedPatterns: oldSelectedPatterns,
    sourcererDataView
  } = (0, _containers2.useSourcererDataView)(_model.SourcererScopeName.timeline);
  const {
    dataView: experimentalDataView
  } = (0, _use_data_view.useDataView)(_model.SourcererScopeName.timeline);
  const experimentalBrowserfields = (0, _use_browser_fields.useBrowserFields)(_constants.DataViewManagerScopeName.timeline);
  const browserFields = newDataViewPickerEnabled ? experimentalBrowserfields : oldBrowserFields;
  const runtimeMappings = newDataViewPickerEnabled ? (_ref = experimentalDataView === null || experimentalDataView === void 0 ? void 0 : experimentalDataView.getRuntimeMappings()) !== null && _ref !== void 0 ? _ref : {} : (_ref2 = sourcererDataView.runtimeFieldMap) !== null && _ref2 !== void 0 ? _ref2 : {};
  const experimentalSelectedPatterns = (0, _use_selected_patterns.useSelectedPatterns)(_constants.DataViewManagerScopeName.timeline);
  const selectedPatterns = newDataViewPickerEnabled ? experimentalSelectedPatterns : oldSelectedPatterns;
  /*
   * `pageIndex` needs to be maintained for each table in each tab independently
   * and consequently it cannot be the part of common redux state
   * of the timeline.
   *
   */

  const {
    uiSettings,
    timelineDataService
  } = (0, _kibana.useKibana)().services;
  const esQueryConfig = (0, _react.useMemo)(() => (0, _common.getEsQueryConfig)(uiSettings), [uiSettings]);
  const kqlQuery = (0, _react.useMemo)(() => ({
    query: kqlQueryExpression.trim(),
    language: kqlQueryLanguage
  }), [kqlQueryExpression, kqlQueryLanguage]);
  const combinedQueries = (0, _react.useMemo)(() => {
    return (0, _kuery.combineQueries)({
      config: esQueryConfig,
      dataProviders,
      dataViewSpec: sourcererDataView,
      dataView: experimentalDataView,
      browserFields,
      filters,
      kqlQuery,
      kqlMode
    });
  }, [esQueryConfig, dataProviders, sourcererDataView, experimentalDataView, browserFields, filters, kqlQuery, kqlMode]);
  (0, _use_invalid_filter_query.useInvalidFilterQuery)({
    id: timelineId,
    filterQuery: combinedQueries === null || combinedQueries === void 0 ? void 0 : combinedQueries.filterQuery,
    kqlError: combinedQueries === null || combinedQueries === void 0 ? void 0 : combinedQueries.kqlError,
    query: kqlQuery,
    startDate: start,
    endDate: end
  });
  const isBlankTimeline = (0, _fp.isEmpty)(dataProviders) && (0, _fp.isEmpty)(filters) && (0, _fp.isEmpty)(kqlQuery.query) && (combinedQueries === null || combinedQueries === void 0 ? void 0 : combinedQueries.filterQuery) === undefined;
  const canQueryTimeline = (0, _react.useMemo)(() => combinedQueries != null && loadingSourcerer != null && !loadingSourcerer && !(0, _fp.isEmpty)(start) && !(0, _fp.isEmpty)(end) && (combinedQueries === null || combinedQueries === void 0 ? void 0 : combinedQueries.filterQuery) !== undefined, [combinedQueries, end, loadingSourcerer, start]);
  const timelineQuerySortField = (0, _react.useMemo)(() => {
    return sort.map(({
      columnId,
      columnType,
      esTypes,
      sortDirection
    }) => ({
      field: columnId,
      direction: sortDirection,
      esTypes: esTypes !== null && esTypes !== void 0 ? esTypes : [],
      type: columnType
    }));
  }, [sort]);
  const {
    defaultColumns
  } = (0, _use_timeline_columns.useTimelineColumns)(columns);
  const [dataLoadingState, {
    totalCount
  }] = (0, _containers.useTimelineEvents)({
    dataViewId,
    endDate: end,
    fields: emptyFieldsList,
    filterQuery: combinedQueries === null || combinedQueries === void 0 ? void 0 : combinedQueries.filterQuery,
    id: timelineId,
    indexNames: selectedPatterns,
    language: kqlQuery.language,
    limit: 0,
    // We only care about the totalCount here
    runtimeMappings,
    skip: !canQueryTimeline,
    sort: timelineQuerySortField,
    startDate: start,
    timerangeKind
  });
  (0, _react.useEffect)(() => {
    dispatch(_store.timelineActions.initializeTimelineSettings({
      id: timelineId,
      defaultColumns
    }));
  }, [dispatch, timelineId, defaultColumns]);

  // NOTE: The timeline is blank after browser FORWARD navigation (after using back button to navigate to
  // the previous page from the timeline), yet we still see total count. This is because the timeline
  // is not getting refreshed when using browser navigation.
  const showEventsCountBadge = !isBlankTimeline && totalCount >= 0;

  // <Synchronisation of the timeline data service>
  // Sync the timerange
  const timelineFilters = (0, _use_timeline_data_filters.useTimelineDataFilters)((0, _helpers.isActiveTimeline)(timelineId));
  (0, _react.useEffect)(() => {
    timelineDataService.query.timefilter.timefilter.setTime({
      from: timelineFilters.from,
      to: timelineFilters.to
    });
  }, [timelineDataService.query.timefilter.timefilter, timelineFilters.from, timelineFilters.to]);

  // Sync the base query
  (0, _react.useEffect)(() => {
    timelineDataService.query.queryString.setQuery(
    // We're using the base query of all combined queries here, to account for all
    // of timeline's query dependencies (data providers, query etc.)
    (combinedQueries === null || combinedQueries === void 0 ? void 0 : combinedQueries.baseKqlQuery) || {
      language: kqlQueryLanguage,
      query: ''
    });
  }, [timelineDataService, combinedQueries, kqlQueryLanguage]);
  // </Synchronisation of the timeline data service>

  if (!showEventsCountBadge) return null;
  return dataLoadingState === _unifiedDataTable.DataLoadingState.loading || dataLoadingState === _unifiedDataTable.DataLoadingState.loadingMore ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 246,
      columnNumber: 5
    }
  }) : /*#__PURE__*/_react.default.createElement(_layout.EventsCountBadge, {
    "data-test-subj": "query-events-count",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 248,
      columnNumber: 5
    }
  }, totalCount);
};
exports.TimelineQueryTabEventsCountComponent = TimelineQueryTabEventsCountComponent;
const TimelineQueryTabEventsCount = exports.default = /*#__PURE__*/_react.default.memo(TimelineQueryTabEventsCountComponent);

// eslint-disable-next-line import/no-default-export