"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchTimelineSuperSelect = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _selectable_timeline = require("../selectable_timeline");
var i18n = _interopRequireWildcard(require("../translations"));
var _timeline = require("../../../../../common/api/timeline");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/timeline/search_super_select/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getBasicSelectableOptions = timelineId => [{
  description: i18n.DEFAULT_TIMELINE_DESCRIPTION,
  favorite: [],
  label: i18n.DEFAULT_TIMELINE_TITLE,
  id: undefined,
  title: i18n.DEFAULT_TIMELINE_TITLE,
  checked: timelineId === '-1' ? 'on' : undefined
}];
const SearchTimelineSuperSelectComponent = ({
  isDisabled,
  hideUntitled = false,
  timelineId,
  timelineTitle,
  timelineType = _timeline.TimelineTypeEnum.template,
  onTimelineChange,
  placeholder,
  'aria-label': ariaLabel
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const handleClosePopover = (0, _react.useCallback)(() => {
    setIsPopoverOpen(false);
  }, []);
  const handlePopover = (0, _react.useCallback)(() => {
    setIsPopoverOpen(isOpen => !isOpen);
  }, []);
  const handleKeyboardOpen = (0, _react.useCallback)(event => {
    if (event.key === _eui.keys.ENTER) {
      setIsPopoverOpen(true);
    }
  }, []);
  const popoverId = (0, _react.useMemo)(() => (0, _eui.htmlIdGenerator)('searchTimelinePopover')(), []);
  const superSelect = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    disabled: isDisabled,
    onClick: handlePopover,
    onKeyDown: handleKeyboardOpen,
    value: timelineTitle !== null && timelineTitle !== void 0 ? timelineTitle : i18n.DEFAULT_TIMELINE_TITLE,
    icon: !isDisabled ? {
      type: 'arrowDown',
      side: 'right'
    } : undefined,
    "aria-label": ariaLabel,
    "aria-controls": popoverId,
    "aria-expanded": isPopoverOpen,
    role: "combobox",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 7
    }
  }), [ariaLabel, handleKeyboardOpen, isDisabled, isPopoverOpen, popoverId, timelineTitle, handlePopover]);
  const handleGetSelectableOptions = (0, _react.useCallback)(({
    timelines,
    onlyFavorites,
    searchTimelineValue
  }) => [...(!onlyFavorites && searchTimelineValue === '' ? getBasicSelectableOptions(timelineId == null ? '-1' : timelineId) : []), ...timelines.filter(t => !hideUntitled || t.title !== '').map((t, index) => ({
    description: t.description,
    favorite: t.favorite,
    label: t.title,
    id: timelineType === _timeline.TimelineTypeEnum.template ? t.templateTimelineId : t.savedObjectId,
    key: `${t.title}-${index}`,
    title: t.title,
    checked: [t.savedObjectId, t.templateTimelineId].includes(timelineId) ? 'on' : undefined
  }))], [hideUntitled, timelineId, timelineType]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInputPopover, {
    id: popoverId,
    input: superSelect,
    isOpen: isPopoverOpen,
    closePopover: handleClosePopover,
    className: "rightArrowIcon",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_selectable_timeline.SelectableTimeline, {
    hideUntitled: hideUntitled,
    getSelectableOptions: handleGetSelectableOptions,
    onClosePopover: handleClosePopover,
    onTimelineChange: onTimelineChange,
    timelineType: timelineType,
    placeholder: placeholder,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 7
    }
  }));
};
const SearchTimelineSuperSelect = exports.SearchTimelineSuperSelect = /*#__PURE__*/(0, _react.memo)(SearchTimelineSuperSelectComponent);