"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EqlQueryBarTimeline = void 0;
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactRedux = require("react-redux");
var _css = require("@emotion/css");
var _use_experimental_features = require("../../../../../common/hooks/use_experimental_features");
var _use_data_view = require("../../../../../data_view_manager/hooks/use_data_view");
var _use_selector = require("../../../../../common/hooks/use_selector");
var _model = require("../../../../../sourcerer/store/model");
var _eql_query_edit = require("../../../../../detection_engine/rule_creation/components/eql_query_edit");
var _shared_imports = require("../../../../../shared_imports");
var _store = require("../../../../store");
var _selectors = require("./selectors");
var _use_selected_patterns = require("../../../../../data_view_manager/hooks/use_selected_patterns");
var _containers = require("../../../../../sourcerer/containers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/timeline/query_bar/eql/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const defaultValues = {
  index: [],
  eqlQueryBar: {
    query: {
      query: '',
      language: 'eql'
    },
    filters: [],
    saved_id: null
  },
  eqlOptions: {}
};
const schema = {
  index: {
    fieldsToValidateOnChange: ['index', 'eqlQueryBar'],
    validations: []
  },
  eqlOptions: {
    fieldsToValidateOnChange: ['eqlOptions', 'eqlQueryBar']
  }
};
const hiddenUseFieldClassName = (0, _css.css)`
  display: none;
`;

// eslint-disable-next-line react/display-name
const EqlQueryBarTimeline = exports.EqlQueryBarTimeline = /*#__PURE__*/(0, _react.memo)(({
  timelineId
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const getOptionsSelected = (0, _react.useMemo)(() => (0, _selectors.getEqlOptions)(), []);
  const eqlOptions = (0, _use_selector.useDeepEqualSelector)(state => getOptionsSelected(state, timelineId));
  const {
    loading: oldIndexPatternsLoading,
    sourcererDataView: oldSourcererDataViewSpec,
    selectedPatterns: oldSelectedPatterns
  } = (0, _containers.useSourcererDataView)(_model.SourcererScopeName.timeline);
  const {
    newDataViewPickerEnabled
  } = (0, _use_experimental_features.useEnableExperimental)();
  const {
    dataView: experimentalDataView,
    status
  } = (0, _use_data_view.useDataView)(_model.SourcererScopeName.timeline);
  const experimentalSelectedPatterns = (0, _use_selected_patterns.useSelectedPatterns)(_model.SourcererScopeName.timeline);
  const indexPatternsLoading = (0, _react.useMemo)(() => newDataViewPickerEnabled ? status !== 'ready' : oldIndexPatternsLoading, [newDataViewPickerEnabled, oldIndexPatternsLoading, status]);
  const selectedPatterns = (0, _react.useMemo)(() => newDataViewPickerEnabled ? experimentalSelectedPatterns : oldSelectedPatterns, [experimentalSelectedPatterns, newDataViewPickerEnabled, oldSelectedPatterns]);
  const initialState = (0, _react.useMemo)(() => {
    var _eqlOptions$query;
    return {
      ...defaultValues,
      index: [...selectedPatterns].sort(),
      eqlQueryBar: {
        ...defaultValues.eqlQueryBar,
        query: {
          query: (_eqlOptions$query = eqlOptions.query) !== null && _eqlOptions$query !== void 0 ? _eqlOptions$query : '',
          language: 'eql'
        }
      },
      eqlOptions
    };
  }, [eqlOptions, selectedPatterns]);
  const handleSubmit = (0, _react.useCallback)(async (formData, isValid) => {
    if (!isValid) {
      return;
    }
    if (eqlOptions.query !== `${formData.eqlQueryBar.query.query}`) {
      dispatch(_store.timelineActions.updateEqlOptions({
        id: timelineId,
        field: 'query',
        value: `${formData.eqlQueryBar.query.query}`
      }));
    }
    for (const fieldName of Object.keys(formData.eqlOptions)) {
      if (formData.eqlOptions[fieldName] !== eqlOptions[fieldName]) {
        dispatch(_store.timelineActions.updateEqlOptions({
          id: timelineId,
          field: fieldName,
          value: formData.eqlOptions[fieldName]
        }));
      }
    }
  }, [dispatch, timelineId, eqlOptions]);
  const {
    form
  } = (0, _shared_imports.useForm)({
    defaultValue: initialState,
    options: {
      stripEmptyFields: false
    },
    schema,
    onSubmit: handleSubmit
  });
  const {
    getFields
  } = form;
  const handleOutsideEqlQueryEditClick = (0, _react.useCallback)(() => form.submit(), [form]);

  // Reset the form when new EQL Query came from the state
  (0, _react.useEffect)(() => {
    var _eqlOptions$query2;
    getFields().eqlQueryBar.setValue({
      ...defaultValues.eqlQueryBar,
      query: {
        query: (_eqlOptions$query2 = eqlOptions.query) !== null && _eqlOptions$query2 !== void 0 ? _eqlOptions$query2 : '',
        language: 'eql'
      }
    });
  }, [getFields, eqlOptions.query]);

  // Reset the form when new EQL Options came from the state
  (0, _react.useEffect)(() => {
    getFields().eqlOptions.setValue({
      eventCategoryField: eqlOptions.eventCategoryField,
      tiebreakerField: eqlOptions.tiebreakerField,
      timestampField: eqlOptions.timestampField,
      size: eqlOptions.size
    });
  }, [getFields, eqlOptions.eventCategoryField, eqlOptions.tiebreakerField, eqlOptions.timestampField, eqlOptions.size]);
  (0, _react.useEffect)(() => {
    const {
      index: indexField
    } = getFields();
    const newIndexValue = [...selectedPatterns].sort();
    const indexFieldValue = indexField.value.sort();
    if (!(0, _lodash.isEqual)(indexFieldValue, newIndexValue)) {
      indexField.setValue(newIndexValue);
    }
  }, [getFields, selectedPatterns]);
  const dataView = (0, _react.useMemo)(() => {
    var _oldSourcererDataView;
    return newDataViewPickerEnabled ? experimentalDataView || {
      title: '',
      fields: []
    } : {
      title: (_oldSourcererDataView = oldSourcererDataViewSpec.title) !== null && _oldSourcererDataView !== void 0 ? _oldSourcererDataView : '',
      fields: Object.values(oldSourcererDataViewSpec.fields || {})
    };
  }, [experimentalDataView, newDataViewPickerEnabled, oldSourcererDataViewSpec]);

  /* Force casting `dataViewSpec` to `DataViewBase` is required since EqlQueryEdit
     accepts DataViewBase but `useSourcererDataView()` returns `DataViewSpec`. Since
     the DataView class inherits from DataViewBase, it is safe to use directly and the prioir statement is only valid
     while sourcerer is not migrated to the new data view picker.
      When using `UseField` with `EqlQueryBar` such casting isn't required by TS since
     `UseField` component props are types as `Record<string, any>`. */
  return /*#__PURE__*/_react.default.createElement(_shared_imports.Form, {
    form: form,
    "data-test-subj": "EqlQueryBarTimeline",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    key: "Index",
    path: "index",
    className: hiddenUseFieldClassName,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiOutsideClickDetector, {
    onOutsideClick: handleOutsideEqlQueryEditClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eql_query_edit.EqlQueryEdit, {
    key: "EqlQueryBar",
    path: "eqlQueryBar",
    eqlOptionsPath: "eqlOptions",
    showEqlSizeOption: true,
    dataView: dataView,
    loading: indexPatternsLoading,
    disabled: indexPatternsLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 9
    }
  })));
});