"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimelineKPIs = exports.StatsContainer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _constants = require("../../../../../common/constants");
var _kibana = require("../../../../common/lib/kibana");
var _empty_value = require("../../../../common/components/empty_value");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/timeline/kpi/kpis.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StatsContainer = exports.StatsContainer = /*#__PURE__*/(0, _react.memo)(({
  children
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement("span", {
    css: (0, _react2.css)`
        font-size: ${euiTheme.font.scale.xs};
        font-weight: ${euiTheme.font.weight.semiBold};
        padding-right: ${euiTheme.size.base};

        .smallDot {
          width: 3px !important;
          display: inline-block;
        }

        .euiBadge__text {
          text-align: center;
          width: 100%;
        }
      `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 21,
      columnNumber: 5
    }
  }, children);
});
StatsContainer.displayName = 'StatsContainer';
const TimelineKPIs = exports.TimelineKPIs = /*#__PURE__*/_react.default.memo(({
  kpis
}) => {
  const kpiFormat = '0,0.[000]a';
  const [defaultNumberFormat] = (0, _kibana.useUiSetting$)(_constants.DEFAULT_NUMBER_FORMAT);
  const formattedKpis = (0, _react.useMemo)(() => {
    return {
      process: kpis === null ? (0, _empty_value.getEmptyValue)() : (0, _numeral.default)(kpis.processCount).format(kpiFormat),
      user: kpis === null ? (0, _empty_value.getEmptyValue)() : (0, _numeral.default)(kpis.userCount).format(kpiFormat),
      host: kpis === null ? (0, _empty_value.getEmptyValue)() : (0, _numeral.default)(kpis.hostCount).format(kpiFormat),
      sourceIp: kpis === null ? (0, _empty_value.getEmptyValue)() : (0, _numeral.default)(kpis.sourceIpCount).format(kpiFormat),
      destinationIp: kpis === null ? (0, _empty_value.getEmptyValue)() : (0, _numeral.default)(kpis.destinationIpCount).format(kpiFormat)
    };
  }, [kpis]);
  const formattedKpiToolTips = (0, _react.useMemo)(() => {
    return {
      process: (0, _numeral.default)(kpis === null || kpis === void 0 ? void 0 : kpis.processCount).format(defaultNumberFormat),
      user: (0, _numeral.default)(kpis === null || kpis === void 0 ? void 0 : kpis.userCount).format(defaultNumberFormat),
      host: (0, _numeral.default)(kpis === null || kpis === void 0 ? void 0 : kpis.hostCount).format(defaultNumberFormat),
      sourceIp: (0, _numeral.default)(kpis === null || kpis === void 0 ? void 0 : kpis.sourceIpCount).format(defaultNumberFormat),
      destinationIp: (0, _numeral.default)(kpis === null || kpis === void 0 ? void 0 : kpis.destinationIpCount).format(defaultNumberFormat)
    };
  }, [kpis, defaultNumberFormat]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    wrap: true,
    "data-test-subj": "siem-timeline-kpis",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(StatsContainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 9
    }
  }, `${i18n.PROCESS_KPI_TITLE} : `, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "left",
    content: formattedKpiToolTips.process,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    "data-test-subj": 'siem-timeline-process-kpi',
    tabIndex: 0,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 13
    }
  }, formattedKpis.process)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(StatsContainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 9
    }
  }, `${i18n.USER_KPI_TITLE} : `, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "left",
    content: formattedKpiToolTips.user,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    "data-test-subj": 'siem-timeline-user-kpi',
    tabIndex: 0,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 13
    }
  }, formattedKpis.user)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(StatsContainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 9
    }
  }, `${i18n.HOST_KPI_TITLE} : `, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "left",
    content: formattedKpiToolTips.host,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    "data-test-subj": 'siem-timeline-host-kpi',
    tabIndex: 0,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 13
    }
  }, formattedKpis.host)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(StatsContainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 9
    }
  }, `${i18n.SOURCE_IP_KPI_TITLE} : `, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "left",
    content: formattedKpiToolTips.sourceIp,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    "data-test-subj": 'siem-timeline-source-ip-kpi',
    tabIndex: 0,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 13
    }
  }, formattedKpis.sourceIp)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      minWidth: 100
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(StatsContainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 9
    }
  }, `${i18n.DESTINATION_IP_KPI_TITLE} : `, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "left",
    content: formattedKpiToolTips.destinationIp,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    "data-test-subj": 'siem-timeline-destination-ip-kpi',
    tabIndex: 0,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 13
    }
  }, formattedKpis.destinationIp)))));
});
TimelineKPIs.displayName = 'TimelineKPIs';