"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Providers = exports.EMPTY_PROVIDERS_GROUP_CLASS_NAME = exports.DataProvidersGroupItem = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _polished = require("polished");
var _react = _interopRequireWildcard(require("react"));
var _dnd = require("@hello-pangea/dnd");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _reactRedux = require("react-redux");
var _securitysolutionTGrid = require("@kbn/securitysolution-t-grid");
var _draggable_keyboard_wrapper_hook = require("../../../../common/components/drag_and_drop/draggable_keyboard_wrapper_hook");
var _store = require("../../../store");
var _and_or_badge = require("../../../../common/components/and_or_badge");
var _add_data_provider_popover = require("./add_data_provider_popover");
var _helpers = require("../../../../common/components/drag_and_drop/helpers");
var _data_provider = require("./data_provider");
var _timeline = require("../../../../../common/api/timeline");
var _helpers2 = require("./helpers");
var _provider_item_badge = require("./provider_item_badge");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/timeline/data_providers/providers.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EMPTY_PROVIDERS_GROUP_CLASS_NAME = exports.EMPTY_PROVIDERS_GROUP_CLASS_NAME = 'empty-providers-group';
/**
 * This fixed height prevents the timeline's droppable area from growing,
 * (growth causes layout thrashing) when the AND drop target in a row
 * of data providers is revealed.
 */
const ROW_OF_DATA_PROVIDERS_HEIGHT = 36; // px

const listStyle = {
  alignItems: 'center',
  display: 'flex',
  height: `${ROW_OF_DATA_PROVIDERS_HEIGHT}px`,
  minWidth: '125px'
};
const getItemStyle = draggableStyle => ({
  ...draggableStyle,
  userSelect: 'none'
});
const DroppableContainer = _styledComponents.default.div`
  min-height: ${ROW_OF_DATA_PROVIDERS_HEIGHT}px;
  height: auto !important;
  display: none;

  .${_securitysolutionTGrid.IS_DRAGGING_CLASS_NAME} &:hover {
    display: flex;
    background-color: ${({
  theme
}) => (0, _polished.rgba)(theme.eui.euiColorSuccess, 0.2)} !important;
  }
`;
const Parens = _styledComponents.default.span`
  color: ${({
  theme
}) => theme.eui.euiColorMediumShade};
  font-size: 32px;
  padding: 2px;
  user-select: none;
`;
const AndOrBadgeContainer = _styledComponents.default.div`
  span {
    visibility: ${({
  hideBadge
}) => hideBadge ? 'hidden' : 'inherit'};
  }
`;
const LastAndOrBadgeInGroup = _styledComponents.default.div`
  display: none;

  .${_securitysolutionTGrid.IS_DRAGGING_CLASS_NAME} & {
    display: initial;
  }
`;
const OrFlexItem = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  padding-left: 9px;
`;
const TimelineEuiFormHelpText = (0, _styledComponents.default)(_eui.EuiFormHelpText)`
  padding-top: 0px;
  position: absolute;
  bottom: 0px;
  left: 4px;
`;
TimelineEuiFormHelpText.displayName = 'TimelineEuiFormHelpText';
const ParensContainer = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  align-self: center;
`;

/**
 * Renders an interactive card representation of the data providers. It also
 * affords uniform UI controls for the following actions:
 * 1) removing a data provider
 * 2) temporarily disabling a data provider
 * 3) applying boolean negation to the data provider
 */
const Providers = exports.Providers = /*#__PURE__*/_react.default.memo(({
  browserFields,
  timelineId,
  dataProviders
}) => {
  // Transform the dataProviders into flattened groups, and append an empty group
  const dataProviderGroups = (0, _react.useMemo)(() => [...(0, _helpers2.flattenIntoAndGroups)(dataProviders), ..._helpers2.EMPTY_GROUP], [dataProviders]);
  const content = (0, _react.useMemo)(() => dataProviderGroups.map((group, groupIndex) => /*#__PURE__*/_react.default.createElement(DataProvidersGroup, {
    key: `droppable-${groupIndex}`,
    group: group,
    groupIndex: groupIndex,
    isLastGroup: groupIndex === dataProviderGroups.length - 1,
    browserFields: browserFields,
    timelineId: timelineId,
    dataProviders: dataProviders,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 9
    }
  })), [browserFields, dataProviderGroups, dataProviders, timelineId]);
  return /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 10
    }
  }, content);
});
Providers.displayName = 'Providers';
const DataProvidersGroupItem = exports.DataProvidersGroupItem = /*#__PURE__*/_react.default.memo(({
  browserFields,
  group,
  groupIndex,
  dataProvider,
  index,
  timelineId
}) => {
  var _dataProvider$queryMa;
  const keyboardHandlerRef = (0, _react.useRef)(null);
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const [, setClosePopOverTrigger] = (0, _react.useState)(false);
  const dispatch = (0, _reactRedux.useDispatch)();
  const handleClosePopOverTrigger = (0, _react.useCallback)(() => {
    setClosePopOverTrigger(prevClosePopOverTrigger => !prevClosePopOverTrigger);
  }, []);
  const draggableId = (0, _react.useMemo)(() => (0, _helpers.getTimelineProviderDraggableId)({
    dataProviderId: dataProvider.id,
    groupIndex,
    timelineId
  }), [dataProvider.id, groupIndex, timelineId]);
  const handleDeleteProvider = (0, _react.useCallback)(() => {
    const payload = {
      id: timelineId,
      providerId: index > 0 ? group[0].id : dataProvider.id,
      andProviderId: index > 0 ? dataProvider.id : undefined
    };
    dispatch(_store.timelineActions.removeProvider(payload));
  }, [dataProvider.id, dispatch, group, index, timelineId]);
  const handleToggleEnabledProvider = (0, _react.useCallback)(() => {
    const payload = {
      id: timelineId,
      providerId: index > 0 ? group[0].id : dataProvider.id,
      enabled: !dataProvider.enabled,
      andProviderId: index > 0 ? dataProvider.id : undefined
    };
    dispatch(_store.timelineActions.updateDataProviderEnabled(payload));
  }, [dataProvider.enabled, dataProvider.id, dispatch, group, index, timelineId]);
  const handleToggleExcludedProvider = (0, _react.useCallback)(() => {
    const payload = {
      id: timelineId,
      providerId: index > 0 ? group[0].id : dataProvider.id,
      excluded: !dataProvider.excluded,
      andProviderId: index > 0 ? dataProvider.id : undefined
    };
    dispatch(_store.timelineActions.updateDataProviderExcluded(payload));
  }, [dataProvider.excluded, dataProvider.id, dispatch, group, index, timelineId]);
  const handleToggleTypeProvider = (0, _react.useCallback)(() => {
    const payload = {
      id: timelineId,
      providerId: index > 0 ? group[0].id : dataProvider.id,
      type: dataProvider.type === _timeline.DataProviderTypeEnum.template ? _timeline.DataProviderTypeEnum.default : _timeline.DataProviderTypeEnum.template,
      andProviderId: index > 0 ? dataProvider.id : undefined
    };
    dispatch(_store.timelineActions.updateDataProviderType(payload));
  }, [dataProvider.id, dataProvider.type, dispatch, group, index, timelineId]);
  const handleDataProviderEdited = (0, _react.useCallback)(({
    andProviderId,
    excluded,
    field,
    operator,
    providerId,
    value
  }) => dispatch(_store.timelineActions.dataProviderEdited({
    andProviderId,
    excluded,
    field,
    id: timelineId,
    operator,
    providerId,
    value
  })), [dispatch, timelineId]);
  const onFocus = (0, _react.useCallback)(() => {
    var _keyboardHandlerRef$c;
    (_keyboardHandlerRef$c = keyboardHandlerRef.current) === null || _keyboardHandlerRef$c === void 0 ? void 0 : _keyboardHandlerRef$c.focus();
  }, []);
  const openPopover = (0, _react.useCallback)(() => {
    setIsPopoverOpen(true);
  }, []);
  const {
    onBlur,
    onKeyDown
  } = (0, _draggable_keyboard_wrapper_hook.useDraggableKeyboardWrapper)({
    closePopover: handleClosePopOverTrigger,
    draggableId,
    fieldName: dataProvider.queryMatch.field,
    keyboardHandlerRef,
    openPopover
  });
  const keyDownHandler = (0, _react.useCallback)(keyboardEvent => {
    if (keyboardHandlerRef.current === document.activeElement) {
      onKeyDown(keyboardEvent);
    }
  }, [onKeyDown]);
  const displayValue = String((_dataProvider$queryMa = dataProvider.queryMatch.displayValue) !== null && _dataProvider$queryMa !== void 0 ? _dataProvider$queryMa : dataProvider.queryMatch.value);
  const DraggableContent = (0, _react.useCallback)((provided, snapshot) => {
    var _dataProvider$queryMa2, _group$0$queryMatch$d, _dataProvider$queryMa3, _group$0$queryMatch$o;
    return /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({
      ref: provided.innerRef
    }, provided.draggableProps, provided.dragHandleProps, {
      style: getItemStyle(provided.draggableProps.style),
      "data-test-subj": "providerContainer",
      tabIndex: -1,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 274,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "none",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 282,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 283,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_provider_item_badge.ProviderItemBadge, {
      andProviderId: index > 0 ? dataProvider.id : undefined,
      browserFields: browserFields,
      deleteProvider: handleDeleteProvider,
      field: index > 0 ? (_dataProvider$queryMa2 = dataProvider.queryMatch.displayField) !== null && _dataProvider$queryMa2 !== void 0 ? _dataProvider$queryMa2 : dataProvider.queryMatch.field : (_group$0$queryMatch$d = group[0].queryMatch.displayField) !== null && _group$0$queryMatch$d !== void 0 ? _group$0$queryMatch$d : group[0].queryMatch.field,
      kqlQuery: index > 0 ? dataProvider.kqlQuery : group[0].kqlQuery,
      isEnabled: index > 0 ? dataProvider.enabled : group[0].enabled,
      isExcluded: index > 0 ? dataProvider.excluded : group[0].excluded,
      isPopoverOpen: isPopoverOpen,
      onDataProviderEdited: handleDataProviderEdited,
      operator: index > 0 ? (_dataProvider$queryMa3 = dataProvider.queryMatch.operator) !== null && _dataProvider$queryMa3 !== void 0 ? _dataProvider$queryMa3 : _data_provider.IS_OPERATOR : (_group$0$queryMatch$o = group[0].queryMatch.operator) !== null && _group$0$queryMatch$o !== void 0 ? _group$0$queryMatch$o : _data_provider.IS_OPERATOR,
      register: dataProvider,
      providerId: index > 0 ? group[0].id : dataProvider.id,
      timelineId: timelineId,
      setIsPopoverOpen: setIsPopoverOpen,
      toggleEnabledProvider: handleToggleEnabledProvider,
      toggleExcludedProvider: handleToggleExcludedProvider,
      toggleTypeProvider: handleToggleTypeProvider,
      displayValue: displayValue,
      val: dataProvider.queryMatch.value,
      type: dataProvider.type,
      wrapperRef: keyboardHandlerRef,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 284,
        columnNumber: 15
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 316,
        columnNumber: 13
      }
    }, !snapshot.isDragging && (index < group.length - 1 ? /*#__PURE__*/_react.default.createElement(_and_or_badge.AndOrBadge, {
      type: "and",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 319,
        columnNumber: 19
      }
    }) : /*#__PURE__*/_react.default.createElement(LastAndOrBadgeInGroup, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 321,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_and_or_badge.AndOrBadge, {
      type: "and",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 322,
        columnNumber: 21
      }
    }))))));
  }, [browserFields, dataProvider, displayValue, group, handleDataProviderEdited, handleDeleteProvider, handleToggleEnabledProvider, handleToggleExcludedProvider, handleToggleTypeProvider, index, isPopoverOpen, keyboardHandlerRef, setIsPopoverOpen, timelineId]);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: _securitysolutionTGrid.DRAGGABLE_KEYBOARD_WRAPPER_CLASS_NAME,
    "data-test-subj": "draggableWrapperKeyboardHandler",
    onClick: onFocus,
    onBlur: onBlur,
    onKeyDown: keyDownHandler,
    ref: keyboardHandlerRef,
    role: "button",
    tabIndex: 0,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 348,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_dnd.Draggable, {
    disableInteractiveElementBlocking: true,
    draggableId: draggableId,
    index: index,
    key: dataProvider.id,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 358,
      columnNumber: 9
    }
  }, DraggableContent));
});
DataProvidersGroupItem.displayName = 'DataProvidersGroupItem';
const DataProvidersGroup = /*#__PURE__*/_react.default.memo(({
  browserFields,
  timelineId,
  group,
  groupIndex,
  isLastGroup
}) => {
  const droppableId = (0, _react.useMemo)(() => (0, _helpers.getTimelineProviderDroppableId)({
    groupIndex,
    timelineId
  }), [groupIndex, timelineId]);
  const GroupDataProviders = (0, _react.useMemo)(() => group.map((dataProvider, index) => /*#__PURE__*/_react.default.createElement(DataProvidersGroupItem, {
    key: dataProvider.id,
    browserFields: browserFields,
    dataProvider: dataProvider,
    index: index,
    timelineId: timelineId,
    group: group,
    groupIndex: groupIndex,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 389,
      columnNumber: 11
    }
  })), [browserFields, group, groupIndex, timelineId]);
  const DroppableContent = (0, _react.useCallback)(droppableProvided => /*#__PURE__*/_react.default.createElement(DroppableContainer, (0, _extends2.default)({
    className: isLastGroup ? EMPTY_PROVIDERS_GROUP_CLASS_NAME : '',
    ref: droppableProvided.innerRef,
    css: listStyle
  }, droppableProvided.droppableProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 404,
      columnNumber: 9
    }
  }), GroupDataProviders, droppableProvided.placeholder), [GroupDataProviders, isLastGroup]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, groupIndex !== 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 419,
      columnNumber: 30
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "aria-label": i18n.GROUP_AREA_ARIA_LABEL(groupIndex),
    alignItems: "center",
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 421,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(OrFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 426,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(AndOrBadgeContainer, {
    hideBadge: groupIndex === 0,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 427,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_and_or_badge.AndOrBadge, {
    type: "or",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 428,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(ParensContainer, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 431,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(Parens, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 432,
      columnNumber: 13
    }
  }, '(')), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 434,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_dnd.Droppable, {
    droppableId: droppableId,
    direction: "horizontal",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 435,
      columnNumber: 13
    }
  }, DroppableContent)), /*#__PURE__*/_react.default.createElement(ParensContainer, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 439,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(Parens, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 440,
      columnNumber: 13
    }
  }, ')')), isLastGroup && /*#__PURE__*/_react.default.createElement(_add_data_provider_popover.AddDataProviderPopover, {
    browserFields: browserFields,
    timelineId: timelineId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 443,
      columnNumber: 13
    }
  })));
});
DataProvidersGroup.displayName = 'DataProvidersGroup';