"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddDataProviderPopover = void 0;
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _uuid = require("uuid");
var _reactRedux = require("react-redux");
var _timeline = require("../../../../../common/api/timeline");
var _use_selector = require("../../../../common/hooks/use_selector");
var _edit_data_provider = require("../../edit_data_provider");
var _helpers = require("./helpers");
var _store = require("../../../store");
var _translations = require("./translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/timeline/data_providers/add_data_provider_popover.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AddFieldPopoverContainer = _styledComponents.default.div`
  min-width: 350px;
`;
const AddDataProviderPopoverComponent = ({
  browserFields,
  timelineId
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const [isAddFilterPopoverOpen, setIsAddFilterPopoverOpen] = (0, _react.useState)(false);
  const getTimeline = (0, _react.useMemo)(() => _store.timelineSelectors.getTimelineByIdSelector(), []);
  const {
    dataProviders,
    timelineType
  } = (0, _use_selector.useDeepEqualSelector)(state => (0, _fp.pick)(['dataProviders', 'timelineType'], getTimeline(state, timelineId)));
  const togglePopoverState = (0, _react.useCallback)(() => setIsAddFilterPopoverOpen(!isAddFilterPopoverOpen), [setIsAddFilterPopoverOpen, isAddFilterPopoverOpen]);
  const handleClosePopover = (0, _react.useCallback)(() => setIsAddFilterPopoverOpen(false), [setIsAddFilterPopoverOpen]);
  const handleDataProviderEdited = (0, _react.useCallback)(({
    andProviderId,
    excluded,
    field,
    id,
    operator,
    providerId,
    value,
    type
  }) => {
    (0, _helpers.addContentToTimeline)({
      dataProviders,
      destination: {
        droppableId: `droppableId.timelineProviders.${timelineId}.group.${dataProviders.length}`,
        index: 0
      },
      dispatch,
      onAddedToTimeline: handleClosePopover,
      providerToAdd: {
        id: providerId,
        name: field,
        enabled: true,
        excluded,
        kqlQuery: '',
        type,
        queryMatch: {
          displayField: undefined,
          displayValue: (0, _helpers.getDisplayValue)(value),
          field,
          value,
          operator
        },
        and: []
      },
      timelineId
    });
  }, [dataProviders, timelineId, dispatch, handleClosePopover]);
  const panels = (0, _react.useMemo)(() => [{
    id: 0,
    width: 400,
    items: [{
      name: _translations.ADD_FIELD_LABEL,
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "plusInCircle",
        size: "m",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 102,
          columnNumber: 19
        }
      }),
      panel: 1
    }, timelineType === _timeline.TimelineTypeEnum.template ? {
      disabled: timelineType !== _timeline.TimelineTypeEnum.template,
      name: _translations.ADD_TEMPLATE_FIELD_LABEL,
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "visText",
        size: "m",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 109,
          columnNumber: 23
        }
      }),
      panel: 2
    } : null].filter(item => item !== null)
  }, {
    id: 1,
    title: _translations.ADD_FIELD_LABEL,
    width: 400,
    content: /*#__PURE__*/_react.default.createElement(_edit_data_provider.StatefulEditDataProvider, {
      browserFields: browserFields,
      field: "",
      isExcluded: false,
      onDataProviderEdited: handleDataProviderEdited,
      operator: ":",
      timelineId: timelineId,
      value: "",
      type: _timeline.DataProviderTypeEnum.default,
      providerId: `${timelineId}-${(0, _uuid.v4)()}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 120,
        columnNumber: 11
      }
    })
  }, {
    id: 2,
    title: _translations.ADD_TEMPLATE_FIELD_LABEL,
    width: 400,
    content: /*#__PURE__*/_react.default.createElement(_edit_data_provider.StatefulEditDataProvider, {
      browserFields: browserFields,
      field: "",
      isExcluded: false,
      onDataProviderEdited: handleDataProviderEdited,
      operator: ":",
      timelineId: timelineId,
      value: "",
      type: _timeline.DataProviderTypeEnum.template,
      providerId: `${timelineId}-${(0, _uuid.v4)()}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 138,
        columnNumber: 11
      }
    })
  }], [browserFields, handleDataProviderEdited, timelineId, timelineType]);
  const button = (0, _react.useMemo)(() => {
    if (timelineType === _timeline.TimelineTypeEnum.template) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        size: "s",
        onClick: togglePopoverState,
        "data-test-subj": "addField",
        iconType: "arrowDown",
        fill: true,
        iconSide: "right",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 158,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 166,
          columnNumber: 11
        }
      }, _translations.ADD_FIELD_LABEL));
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "s",
      onClick: togglePopoverState,
      "data-test-subj": "addField",
      iconSide: "right",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 172,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 178,
        columnNumber: 9
      }
    }, `+ ${_translations.ADD_FIELD_LABEL}`));
  }, [togglePopoverState, timelineType]);
  const content = (0, _react.useMemo)(() => {
    if (timelineType === _timeline.TimelineTypeEnum.template) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
        initialPanelId: 0,
        panels: panels,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 185,
          columnNumber: 14
        }
      });
    }
    return /*#__PURE__*/_react.default.createElement(_edit_data_provider.StatefulEditDataProvider, {
      browserFields: browserFields,
      field: "",
      isExcluded: false,
      onDataProviderEdited: handleDataProviderEdited,
      operator: ":",
      timelineId: timelineId,
      value: "",
      type: _timeline.DataProviderTypeEnum.default,
      providerId: `${timelineId}-${(0, _uuid.v4)()}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 189,
        columnNumber: 7
      }
    });
  }, [browserFields, handleDataProviderEdited, panels, timelineId, timelineType]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "addFieldsPopover",
    button: button,
    isOpen: isAddFilterPopoverOpen,
    closePopover: handleClosePopover,
    anchorPosition: "downLeft",
    panelPaddingSize: "none",
    repositionOnScroll: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 204,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(AddFieldPopoverContainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 7
    }
  }, content));
};
AddDataProviderPopoverComponent.displayName = 'AddDataProviderPopoverComponent';
const AddDataProviderPopover = exports.AddDataProviderPopover = /*#__PURE__*/_react.default.memo(AddDataProviderPopoverComponent);
AddDataProviderPopover.displayName = 'AddDataProviderPopover';