"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddToFavoritesButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _selectors = require("../../store/selectors");
var _store = require("../../store");
var _timeline = require("../../../../common/api/timeline");
var _user_privileges = require("../../../common/components/user_privileges");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/add_to_favorites/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ADD_TO_FAVORITES = _i18n.i18n.translate('xpack.securitySolution.timeline.addToFavoriteButtonLabel', {
  defaultMessage: 'Add to favorites'
});
const REMOVE_FROM_FAVORITES = _i18n.i18n.translate('xpack.securitySolution.timeline.removeFromFavoritesButtonLabel', {
  defaultMessage: 'Remove from favorites'
});
/**
 * This component renders the add to favorites button for timeline.
 * It is used in the bottom bar as well as in the timeline modal's header.
 */
const AddToFavoritesButton = exports.AddToFavoritesButton = /*#__PURE__*/_react.default.memo(({
  timelineId
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    isFavorite,
    status
  } = (0, _reactRedux.useSelector)(state => (0, _selectors.selectTimelineById)(state, timelineId));
  const {
    timelinePrivileges: {
      crud: canWriteTimeline
    }
  } = (0, _user_privileges.useUserPrivileges)();
  const isTimelineDraftOrImmutable = status !== _timeline.TimelineStatusEnum.active;
  const isDisabled = !canWriteTimeline || isTimelineDraftOrImmutable;
  const label = isFavorite ? REMOVE_FROM_FAVORITES : ADD_TO_FAVORITES;
  const handleClick = (0, _react.useCallback)(() => dispatch(_store.timelineActions.updateIsFavorite({
    id: timelineId,
    isFavorite: !isFavorite
  })), [dispatch, timelineId, isFavorite]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: isFavorite ? 'starFilled' : 'starEmpty',
    isSelected: isFavorite,
    disabled: isDisabled,
    "aria-label": label,
    title: label,
    "data-test-subj": `timeline-favorite-${isFavorite ? 'filled' : 'empty'}-star`,
    onClick: handleClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 5
    }
  }, label);
});
AddToFavoritesButton.displayName = 'AddToFavoritesButton';