"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIndicatorFieldAndValue = exports.fieldAndValueValid = void 0;
var _common = require("../../../constants/common");
var _unwrap_value = require("./unwrap_value");
var _indicator = require("../../../../../common/threat_intelligence/types/indicator");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const normalize = v => {
  if (v == null) return null;
  if (Array.isArray(v)) return v.length > 0 ? v[0] : null;
  return v;
};

/**
 * Retrieves a field/value pair from an Indicator
 * @param data the {@link Indicator} to extract the value for the field
 * @param field the Indicator's field
 * @returns the key/value pair (indicator's field/value)
 */
const getIndicatorFieldAndValue = (data, field) => {
  const rawValue = (0, _unwrap_value.unwrapValue)(data, field);
  const value = normalize(rawValue);
  let key = field;
  if (field === _indicator.RawIndicatorFieldId.Name) {
    const nameOrigin = normalize((0, _unwrap_value.unwrapValue)(data, _indicator.RawIndicatorFieldId.NameOrigin));
    if (nameOrigin) {
      key = nameOrigin;
    }
  }
  return {
    key,
    value
  };
};

/**
 * Checks if field and value are correct
 * @param field Indicator string field
 * @param value Indicator string|null value for the field
 * @returns true if correct, false if not
 */
exports.getIndicatorFieldAndValue = getIndicatorFieldAndValue;
const fieldAndValueValid = (field, value) => !!value && value !== _common.EMPTY_VALUE && !!field;
exports.fieldAndValueValid = fieldAndValueValid;