"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndicatorsTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _kibana = require("../../../../../common/lib/kibana");
var _cell_actions = require("./cell_actions");
var _cell_popover_renderer = require("./cell_popover_renderer");
var _cell_renderer = require("./cell_renderer");
var _indicator = require("../../../../../../common/threat_intelligence/types/indicator");
var _empty_state = require("../../../../components/empty_state");
var _use_table_context = require("../../hooks/use_table_context");
var _flyout = require("../flyout/flyout");
var _use_toolbar_options = require("../../hooks/use_toolbar_options");
var _use_field_types = require("../../../../hooks/use_field_types");
var _get_field_schema = require("../../utils/get_field_schema");
var _test_ids = require("./test_ids");
var _timeline_capabilities = require("../../../../../common/utils/timeline_capabilities");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/threat_intelligence/modules/indicators/components/table/table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const actionsColumnIconWidth = 32;
const gridStyle = {
  border: 'none',
  header: 'underline',
  cellPadding: 'm',
  fontSize: 's'
};
const IndicatorsTable = ({
  indicators,
  indicatorCount,
  onChangePage,
  onChangeItemsPerPage,
  pagination,
  isLoading,
  isFetching,
  browserFields,
  columnSettings: {
    columns,
    columnVisibility,
    handleResetColumns,
    handleToggleColumn,
    sorting
  }
}) => {
  const {
    application: {
      capabilities
    }
  } = (0, _kibana.useKibana)().services;
  const {
    read: hasAccessToTimeline
  } = (0, _timeline_capabilities.extractTimelineCapabilities)(capabilities);
  const [expanded, setExpanded] = (0, _react.useState)();
  const fieldTypes = (0, _use_field_types.useFieldTypes)();
  const renderCellValue = (0, _react.useMemo)(() => (0, _cell_renderer.cellRendererFactory)(pagination.pageIndex * pagination.pageSize), [pagination.pageIndex, pagination.pageSize]);
  const renderCellPopoverValue = (0, _react.useMemo)(() => (0, _cell_popover_renderer.cellPopoverRendererFactory)(indicators, pagination), [indicators, pagination]);
  const indicatorTableContextValue = (0, _react.useMemo)(() => ({
    expanded,
    setExpanded,
    indicators
  }), [expanded, indicators]);
  const start = pagination.pageIndex * pagination.pageSize;
  const end = start + pagination.pageSize;
  const leadingControlColumns = (0, _react.useMemo)(() => [{
    id: 'Actions',
    width: hasAccessToTimeline ? 3 * actionsColumnIconWidth : 2 * actionsColumnIconWidth,
    headerCellRender: () => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.threatIntelligence.indicator.table.actionColumnLabel",
      defaultMessage: "Actions",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 111,
        columnNumber: 11
      }
    }),
    rowCellRender: renderCellValue
  }], [renderCellValue, hasAccessToTimeline]);
  const mappedColumns = (0, _react.useMemo)(() => columns.map(col => {
    var _browserFields$col$id;
    return {
      ...col,
      isSortable: col.id !== _indicator.RawIndicatorFieldId.Id && ((_browserFields$col$id = browserFields[col.id]) === null || _browserFields$col$id === void 0 ? void 0 : _browserFields$col$id.aggregatable),
      schema: (0, _get_field_schema.getFieldSchema)(fieldTypes[col.id]),
      cellActions: [({
        rowIndex,
        columnId,
        Component
      }) => /*#__PURE__*/_react.default.createElement(_cell_actions.CellActions, {
        rowIndex: rowIndex,
        columnId: columnId,
        Component: Component,
        indicators: indicators,
        pagination: pagination,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 131,
          columnNumber: 15
        }
      })]
    };
  }), [browserFields, columns, fieldTypes, indicators, pagination]);
  const toolbarOptions = (0, _use_toolbar_options.useToolbarOptions)({
    browserFields,
    start,
    end,
    indicatorCount,
    columns,
    onResetColumns: handleResetColumns,
    onToggleColumn: handleToggleColumn
  });
  const flyoutFragment = (0, _react.useMemo)(() => expanded ? /*#__PURE__*/_react.default.createElement(_flyout.IndicatorsFlyout, {
    indicator: expanded,
    closeFlyout: () => setExpanded(undefined),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 9
    }
  }) : null, [expanded]);
  const gridFragment = (0, _react.useMemo)(() => {
    if (isLoading) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        justifyContent: "spaceAround",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 166,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 167,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
        hasShadow: false,
        hasBorder: false,
        paddingSize: "xl",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 168,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
        size: "xl",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 169,
          columnNumber: 15
        }
      }))));
    }
    if (!indicatorCount) {
      return /*#__PURE__*/_react.default.createElement(_empty_state.EmptyState, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 177,
          columnNumber: 14
        }
      });
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isFetching && /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
      "data-test-subj": _test_ids.TABLE_UPDATE_PROGRESS_TEST_ID,
      size: "xs",
      color: "accent",
      position: "absolute",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 183,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 190,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiDataGrid, {
      "aria-labelledby": "indicators-table",
      leadingControlColumns: leadingControlColumns,
      rowCount: indicatorCount,
      renderCellValue: renderCellValue,
      renderCellPopover: renderCellPopoverValue,
      toolbarVisibility: toolbarOptions,
      pagination: {
        ...pagination,
        onChangeItemsPerPage,
        onChangePage
      },
      gridStyle: gridStyle,
      "data-test-subj": _test_ids.TABLE_TEST_ID,
      sorting: sorting,
      columnVisibility: columnVisibility,
      columns: mappedColumns,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 192,
        columnNumber: 9
      }
    }));
  }, [isLoading, indicatorCount, isFetching, leadingControlColumns, renderCellValue, renderCellPopoverValue, toolbarOptions, pagination, onChangeItemsPerPage, onChangePage, sorting, columnVisibility, mappedColumns]);
  return /*#__PURE__*/_react.default.createElement(_use_table_context.IndicatorsTableContext.Provider, {
    value: indicatorTableContextValue,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: {
      position: 'relative'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 230,
      columnNumber: 7
    }
  }, flyoutFragment, gridFragment));
};
exports.IndicatorsTable = IndicatorsTable;