"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TakeAction = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _can_add_to_block_list = require("../../../block_list/utils/can_add_to_block_list");
var _add_to_block_list = require("../../../block_list/components/add_to_block_list");
var _add_to_new_case = require("../../../cases/components/add_to_new_case");
var _add_to_existing_case = require("../../../cases/components/add_to_existing_case");
var _investigate_in_timeline = require("../../../timeline/components/investigate_in_timeline");
var _test_ids = require("./test_ids");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/threat_intelligence/modules/indicators/components/flyout/take_action.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Component rendered at the bottom of the indicators flyout
 */
const TakeAction = ({
  indicator
}) => {
  const [isPopoverOpen, setPopover] = (0, _react.useState)(false);
  const smallContextMenuPopoverId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'smallContextMenuPopover'
  });
  const closePopover = () => {
    setPopover(false);
  };
  const indicatorValue = (0, _can_add_to_block_list.canAddToBlockList)(indicator);
  const items = [/*#__PURE__*/_react.default.createElement(_investigate_in_timeline.InvestigateInTimelineContextMenu, {
    data: indicator,
    onClick: closePopover,
    "data-test-subj": _test_ids.INVESTIGATE_IN_TIMELINE_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_add_to_existing_case.AddToExistingCase, {
    indicator: indicator,
    onClick: closePopover,
    "data-test-subj": _test_ids.ADD_TO_EXISTING_CASE_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_add_to_new_case.AddToNewCase, {
    indicator: indicator,
    onClick: closePopover,
    "data-test-subj": _test_ids.ADD_TO_NEW_CASE_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_add_to_block_list.AddToBlockListContextMenu, {
    data: indicatorValue,
    onClick: closePopover,
    "data-test-subj": _test_ids.ADD_TO_BLOCK_LIST_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 5
    }
  })];
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: "arrowDown",
    iconSide: "right",
    onClick: () => setPopover(!isPopoverOpen),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.threatIntelligence.indicators.flyout.take-action.button",
    defaultMessage: "Take action",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 7
    }
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: smallContextMenuPopoverId,
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    anchorPosition: "downLeft",
    "data-test-subj": _test_ids.TAKE_ACTION_BUTTON_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    size: "s",
    items: items,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 7
    }
  }));
};
exports.TakeAction = TakeAction;