"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndicatorBarchartLegendAction = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _eui = require("@elastic/eui");
var _store = require("../../../../../common/store");
var _copy_to_clipboard = require("../common/copy_to_clipboard");
var _filter_in = require("../../../query_bar/components/filter_in");
var _filter_out = require("../../../query_bar/components/filter_out");
var _add_to_timeline = require("../../../timeline/components/add_to_timeline");
var _test_ids = require("./test_ids");
var _translations = require("./translations");
var _utils = require("./utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/threat_intelligence/modules/indicators/components/barchart/legend_action.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const IndicatorBarchartLegendAction = ({
  data,
  field,
  announceIndicatorActionChange
}) => {
  const [isPopoverOpen, setPopover] = (0, _react.useState)(false);
  const group = field.value === 'date' ? (0, _utils.timestampToIsoString)(data) : data;
  const popoverItems = [/*#__PURE__*/_react.default.createElement(_filter_in.FilterInContextMenu, {
    key: _test_ids.FILTER_IN_BUTTON_TEST_ID,
    data: group,
    field: field.label,
    onAnnounce: announceIndicatorActionChange,
    "data-test-subj": _test_ids.FILTER_IN_BUTTON_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_filter_out.FilterOutContextMenu, {
    key: _test_ids.FILTER_OUT_BUTTON_TEST_ID,
    data: group,
    field: field.label,
    onAnnounce: announceIndicatorActionChange,
    "data-test-subj": _test_ids.FILTER_OUT_BUTTON_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_add_to_timeline.AddToTimelineContextMenu, {
    key: _test_ids.TIMELINE_BUTTON_TEST_ID,
    data: group,
    field: field.label,
    "data-test-subj": _test_ids.TIMELINE_BUTTON_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_copy_to_clipboard.CopyToClipboardContextMenu, {
    key: _test_ids.COPY_TO_CLIPBOARD_BUTTON_TEST_ID,
    value: group,
    "data-test-subj": _test_ids.COPY_TO_CLIPBOARD_BUTTON_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 5
    }
  })];
  const store = (0, _store.getStore)();
  if (!store) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    "data-test-subj": _test_ids.POPOVER_BUTTON_TEST_ID,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _translations.BUTTON_LABEL,
      disableScreenReaderOutput: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 87,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "aria-label": _translations.BUTTON_LABEL,
      iconType: "boxesHorizontal",
      iconSize: "s",
      size: "xs",
      onClick: () => setPopover(prevIsPopoverOpen => !prevIsPopoverOpen),
      css: {
        height: '100%'
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 88,
        columnNumber: 11
      }
    })),
    isOpen: isPopoverOpen,
    closePopover: () => setPopover(false),
    panelPaddingSize: "none",
    anchorPosition: "downLeft",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_reactRedux.Provider, {
    store: store,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    size: "s",
    items: popoverItems,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 9
    }
  })));
};
exports.IndicatorBarchartLegendAction = IndicatorBarchartLegendAction;