"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpdateDefaultDataViewModal = void 0;
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var i18n = _interopRequireWildcard(require("./translations"));
var _helpers = require("./helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/sourcerer/components/update_default_data_view_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MyEuiModal = (0, _styledComponents.default)(_eui.EuiModal)`
  .euiModal__flex {
    width: 60vw;
  }
  .euiCodeBlock {
    height: auto !important;
    max-width: 718px;
  }
`;
const UpdateDefaultDataViewModal = exports.UpdateDefaultDataViewModal = /*#__PURE__*/_react.default.memo(({
  isShowing,
  onDismissModal,
  onContinue,
  onUpdate,
  missingPatterns
}) => isShowing ? /*#__PURE__*/_react.default.createElement(MyEuiModal, {
  onClose: onDismissModal,
  "data-test-subj": "sourcerer-update-data-view-modal",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 45,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 46,
    columnNumber: 9
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 47,
    columnNumber: 11
  }
}, i18n.UPDATE_SECURITY_DATA_VIEW)), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 49,
    columnNumber: 9
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 50,
    columnNumber: 11
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
  color: "subdued",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 51,
    columnNumber: 13
  }
}, /*#__PURE__*/_react.default.createElement("p", {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 52,
    columnNumber: 15
  }
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.securitySolution.indexPatterns.missingPatterns",
  defaultMessage: "Security Data View is missing the following index patterns in order to recreate the previous timeline's data view: {callout}",
  values: {
    callout: /*#__PURE__*/_react.default.createElement(_helpers.Blockquote, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 57,
        columnNumber: 30
      }
    }, missingPatterns.join(', '))
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 53,
    columnNumber: 17
  }
}), i18n.UPDATE_DATA_VIEW))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  alignItems: "center",
  justifyContent: "flexEnd",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 64,
    columnNumber: 11
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 65,
    columnNumber: 13
  }
}, /*#__PURE__*/_react.default.createElement(_helpers.ResetButton, {
  "aria-label": i18n.CONTINUE_WITHOUT_ADDING,
  "data-test-subj": "sourcerer-continue-close",
  flush: "left",
  onClick: onContinue,
  title: i18n.CONTINUE_WITHOUT_ADDING,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 66,
    columnNumber: 15
  }
}, i18n.CONTINUE_WITHOUT_ADDING)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 76,
    columnNumber: 13
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
  "data-test-subj": "sourcerer-update-data-view",
  fill: true,
  fullWidth: true,
  onClick: onUpdate,
  size: "s",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 77,
    columnNumber: 15
  }
}, i18n.ADD_INDEX_PATTERN))))) : null);
UpdateDefaultDataViewModal.displayName = 'UpdateDefaultDataViewModal';