"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePillarsProps = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const usePillarsProps = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const pillarPropsMap = {
    visibility: {
      pillarKey: 'visibility',
      displayName: _i18n.i18n.translate('xpack.securitySolution.siemReadiness.visibility.displayName', {
        defaultMessage: 'Visibility'
      }),
      color: euiTheme.colors.vis.euiColorVisBehindText2,
      description: _i18n.i18n.translate('xpack.securitySolution.siemReadiness.visibility.description', {
        defaultMessage: 'Your visibility score is how well your systems are monitored through logs, agents, and cloud telemetry.'
      }),
      icon: 'eye'
    },
    detection: {
      pillarKey: 'detection',
      displayName: _i18n.i18n.translate('xpack.securitySolution.siemReadiness.detection.displayName', {
        defaultMessage: 'Detection'
      }),
      color: euiTheme.colors.vis.euiColorVisBehindText4,
      description: _i18n.i18n.translate('xpack.securitySolution.siemReadiness.detection.description', {
        defaultMessage: 'Detections measure how well your system identifies threats through tuned, active detection rules.'
      }),
      icon: 'securitySignal'
    },
    response: {
      pillarKey: 'response',
      displayName: _i18n.i18n.translate('xpack.securitySolution.siemReadiness.response.displayName', {
        defaultMessage: 'Response'
      }),
      color: euiTheme.colors.vis.euiColorVisBehindText0,
      description: _i18n.i18n.translate('xpack.securitySolution.siemReadiness.response.description', {
        defaultMessage: 'Response shows how quickly and effectively your team investigates and acts on detected threats.'
      }),
      icon: 'magnifyWithExclamation'
    }
  };
  return {
    pillarPropsMap
  };
};
exports.usePillarsProps = usePillarsProps;