"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createAuthorColumn = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../../common/siem_migrations/constants");
var i18n = _interopRequireWildcard(require("./translations"));
var _constants2 = require("./constants");
var _components = require("../../../common/components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/siem_migrations/rules/components/rules_table_columns/author.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const Author = ({
  isPrebuiltRule
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 19,
      columnNumber: 5
    }
  }, isPrebuiltRule && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 21,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "logoElastic",
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 22,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 25,
      columnNumber: 7
    }
  }, isPrebuiltRule ? i18n.ELASTIC_AUTHOR_TITLE : i18n.CUSTOM_AUTHOR_TITLE));
};
const createAuthorColumn = () => {
  return {
    field: 'elastic_rule.prebuilt_rule_id',
    name: /*#__PURE__*/_react.default.createElement(_components.TableHeader, {
      title: i18n.COLUMN_AUTHOR,
      tooltipContent: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.siemMigrations.rules.tableColumn.authorTooltip",
        defaultMessage: "{title} {elastic} authored rules have been created and are maintained by Elastic. {lineBreak} {custom} rules are any rules that are not authored by Elastic and will not be maintained or updated automatically.",
        values: {
          lineBreak: /*#__PURE__*/_react.default.createElement("br", {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 45,
              columnNumber: 26
            }
          }),
          title: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
            size: "s",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 47,
              columnNumber: 17
            }
          }, /*#__PURE__*/_react.default.createElement("p", {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 48,
              columnNumber: 19
            }
          }, /*#__PURE__*/_react.default.createElement("b", {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 49,
              columnNumber: 21
            }
          }, i18n.COLUMN_AUTHOR), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
            margin: "s",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 50,
              columnNumber: 21
            }
          }))),
          elastic: /*#__PURE__*/_react.default.createElement("b", {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 54,
              columnNumber: 24
            }
          }, i18n.ELASTIC_AUTHOR_TITLE),
          custom: /*#__PURE__*/_react.default.createElement("b", {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 55,
              columnNumber: 23
            }
          }, i18n.CUSTOM_AUTHOR_TITLE)
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 39,
          columnNumber: 11
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 36,
        columnNumber: 7
      }
    }),
    render: (_, rule) => {
      var _rule$elastic_rule;
      return rule.status === _constants.SiemMigrationStatus.FAILED ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _constants2.COLUMN_EMPTY_VALUE) : /*#__PURE__*/_react.default.createElement(Author, {
        isPrebuiltRule: !!((_rule$elastic_rule = rule.elastic_rule) !== null && _rule$elastic_rule !== void 0 && _rule$elastic_rule.prebuilt_rule_id),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 65,
          columnNumber: 9
        }
      });
    },
    sortable: true,
    truncateText: true,
    width: '10%'
  };
};
exports.createAuthorColumn = createAuthorColumn;