"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MigrationRulesTable = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _use_is_open_state = require("../../../../common/hooks/use_is_open_state");
var _utils = require("../../../../../common/siem_migrations/rules/utils");
var _use_app_toasts = require("../../../../common/hooks/use_app_toasts");
var _use_migration_rules_table_columns = require("../../hooks/use_migration_rules_table_columns");
var _use_migration_rule_preview_flyout = require("../../hooks/use_migration_rule_preview_flyout");
var _use_install_migration_rule = require("../../logic/use_install_migration_rule");
var _use_install_migration_rules = require("../../logic/use_install_migration_rules");
var _use_get_migration_rules = require("../../logic/use_get_migration_rules");
var _use_get_migration_translation_stats = require("../../logic/use_get_migration_translation_stats");
var _use_get_migration_prebuilt_rules = require("../../logic/use_get_migration_prebuilt_rules");
var _use_update_index_pattern = require("../../logic/use_update_index_pattern");
var logicI18n = _interopRequireWildcard(require("../../logic/translations"));
var _bulk_actions = require("./bulk_actions");
var _constants = require("../../../../../common/siem_migrations/constants");
var i18n = _interopRequireWildcard(require("./translations"));
var _filters = require("./filters");
var _filters2 = require("./utils/filters");
var _translation_guide = require("../tours/translation_guide");
var _update_index_pattern = require("./update_index_pattern");
var _components = require("../../../common/components");
var _utility_bar = require("../../../../common/components/utility_bar");
var _use_start_rules_migration_modal = require("../../hooks/use_start_rules_migration_modal");
var _use_start_migration = require("../../logic/use_start_migration");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/siem_migrations/rules/components/rules_table/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DEFAULT_PAGE_SIZE = 10;
const DEFAULT_SORT_FIELD = 'translation_result';
const DEFAULT_SORT_DIRECTION = 'desc';
/**
 * Table Component for displaying SIEM rules migrations
 */
const MigrationRulesTable = exports.MigrationRulesTable = /*#__PURE__*/_react.default.memo(({
  refetchData,
  integrations,
  isIntegrationsLoading,
  migrationStats
}) => {
  var _pagination$pageSize, _pagination$pageSize2;
  const migrationId = migrationStats.id;
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  const [pageIndex, setPageIndex] = (0, _react.useState)(0);
  const [pageSize, setPageSize] = (0, _react.useState)(DEFAULT_PAGE_SIZE);
  const [sortField, setSortField] = (0, _react.useState)(DEFAULT_SORT_FIELD);
  const [sortDirection, setSortDirection] = (0, _react.useState)(DEFAULT_SORT_DIRECTION);
  const [searchTerm, setSearchTerm] = (0, _react.useState)();
  const {
    isOpen: isMissingIndexPatternFlyoutOpen,
    open: openMissingIndexPatternFlyout,
    close: closeMissingIndexPatternFlyout
  } = (0, _use_is_open_state.useIsOpenState)(false);
  // Filters
  const [filterOptions, setFilterOptions] = (0, _react.useState)();
  const {
    data: translationStats,
    isLoading: isStatsLoading,
    refetch: refetchTranslationStats
  } = (0, _use_get_migration_translation_stats.useGetMigrationTranslationStats)(migrationId);
  const {
    data: prebuiltRules = {},
    isLoading: isPrebuiltRulesLoading
  } = (0, _use_get_migration_prebuilt_rules.useGetMigrationPrebuiltRules)(migrationId);
  const filters = (0, _react.useMemo)(() => ({
    searchTerm,
    ...(0, _filters2.convertFilterOptions)(filterOptions)
  }), [searchTerm, filterOptions]);
  const {
    data: {
      migrationRules,
      total
    } = {
      migrationRules: [],
      total: 0
    },
    isLoading: isDataLoading
  } = (0, _use_get_migration_rules.useGetMigrationRules)({
    migrationId,
    page: pageIndex,
    perPage: pageSize,
    sortField,
    sortDirection,
    filters
  });
  const [selectedMigrationRules, setSelectedMigrationRules] = (0, _react.useState)([]);
  const onSelectionChange = (0, _react.useCallback)(selectedRules => {
    setSelectedMigrationRules(selectedRules);
  }, []);
  const tableSelection = (0, _react.useMemo)(() => ({
    selectable: item => {
      if (item.translation_result === _constants.MigrationTranslationResult.FULL) {
        var _item$elastic_rule;
        return !((_item$elastic_rule = item.elastic_rule) !== null && _item$elastic_rule !== void 0 && _item$elastic_rule.id);
      } else {
        var _item$elastic_rule$qu, _item$elastic_rule2, _item$elastic_rule2$q;
        return (_item$elastic_rule$qu = (_item$elastic_rule2 = item.elastic_rule) === null || _item$elastic_rule2 === void 0 ? void 0 : (_item$elastic_rule2$q = _item$elastic_rule2.query) === null || _item$elastic_rule2$q === void 0 ? void 0 : _item$elastic_rule2$q.includes(_constants.SIEM_RULE_MIGRATION_INDEX_PATTERN_PLACEHOLDER)) !== null && _item$elastic_rule$qu !== void 0 ? _item$elastic_rule$qu : false;
      }
    },
    selectableMessage: (selectable, item) => {
      var _item$elastic_rule3;
      if (selectable) {
        return '';
      }
      return (_item$elastic_rule3 = item.elastic_rule) !== null && _item$elastic_rule3 !== void 0 && _item$elastic_rule3.id ? i18n.ALREADY_TRANSLATED_RULE_TOOLTIP : i18n.NOT_FULLY_TRANSLATED_RULE_TOOLTIP;
    },
    onSelectionChange,
    selected: selectedMigrationRules
  }), [onSelectionChange, selectedMigrationRules]);
  const pagination = (0, _react.useMemo)(() => {
    return {
      pageIndex,
      pageSize,
      totalItemCount: total
    };
  }, [pageIndex, pageSize, total]);
  const sorting = (0, _react.useMemo)(() => {
    return {
      sort: {
        field: sortField,
        direction: sortDirection
      }
    };
  }, [sortDirection, sortField]);
  const onTableChange = (0, _react.useCallback)(({
    page,
    sort
  }) => {
    if (page) {
      setPageIndex(page.index);
      setPageSize(page.size);
    }
    if (sort) {
      const {
        field,
        direction
      } = sort;
      setSortField(field);
      setSortDirection(direction);
    }
  }, []);
  const handleOnSearch = (0, _react.useCallback)(value => {
    setSearchTerm(value.trim());
  }, []);
  const {
    mutateAsync: installMigrationRule
  } = (0, _use_install_migration_rule.useInstallMigrationRule)(migrationId);
  const {
    mutateAsync: installMigrationRules
  } = (0, _use_install_migration_rules.useInstallMigrationRules)(migrationId, translationStats);
  const {
    mutateAsync: updateIndexPattern
  } = (0, _use_update_index_pattern.useUpdateIndexPattern)({
    onSuccess: () => {
      refetchData === null || refetchData === void 0 ? void 0 : refetchData();
      refetchTranslationStats();
      closeMissingIndexPatternFlyout();
    }
  });
  const [isTableLoading, setTableLoading] = (0, _react.useState)(false);
  const onSubmitMissingIndexPattern = (0, _react.useCallback)(async indexPattern => {
    setTableLoading(true);
    await updateIndexPattern({
      migrationId,
      indexPattern,
      ids: selectedMigrationRules.map(rule => rule.id)
    });
    setTableLoading(false);
    setSelectedMigrationRules([]);
  }, [migrationId, updateIndexPattern, selectedMigrationRules, setTableLoading]);
  const installSingleRule = (0, _react.useCallback)(async (migrationRule, enabled) => {
    setTableLoading(true);
    try {
      await installMigrationRule({
        migrationRule,
        enabled
      });
    } catch (error) {
      addError(error, {
        title: logicI18n.INSTALL_MIGRATION_RULES_FAILURE
      });
    } finally {
      setTableLoading(false);
    }
  }, [addError, installMigrationRule]);
  const installSelectedRule = (0, _react.useCallback)(async enabled => {
    setTableLoading(true);
    try {
      await installMigrationRules({
        ids: selectedMigrationRules.map(rule => rule.id),
        enabled
      });
    } catch (error) {
      addError(error, {
        title: logicI18n.INSTALL_MIGRATION_RULES_FAILURE
      });
    } finally {
      setTableLoading(false);
      setSelectedMigrationRules([]);
    }
  }, [addError, installMigrationRules, selectedMigrationRules]);
  const installTranslatedRules = (0, _react.useCallback)(async enabled => {
    setTableLoading(true);
    try {
      await installMigrationRules({
        enabled
      });
    } catch (error) {
      addError(error, {
        title: logicI18n.INSTALL_MIGRATION_RULES_FAILURE
      });
    } finally {
      setTableLoading(false);
    }
  }, [addError, installMigrationRules]);
  const {
    startMigration,
    isLoading: isStarting
  } = (0, _use_start_migration.useStartMigration)(refetchData);
  const onStartMigrationWithSettings = (0, _react.useCallback)(settings => {
    startMigration(migrationId, _constants.SiemMigrationRetryFilter.FAILED, settings);
  }, [migrationId, startMigration]);
  const {
    modal: reprocessMigrationModal,
    showModal: showReprocessMigrationModal
  } = (0, _use_start_rules_migration_modal.useStartRulesMigrationModal)({
    type: 'reprocess',
    migrationStats,
    translationStats,
    onStartMigrationWithSettings
  });
  const isRulesLoading = isPrebuiltRulesLoading || isDataLoading || isTableLoading || isStarting;
  const ruleActionsFactory = (0, _react.useCallback)((migrationRule, closeRulePreview) => {
    var _migrationRule$elasti;
    const canMigrationRuleBeInstalled = !isRulesLoading && !((_migrationRule$elasti = migrationRule.elastic_rule) !== null && _migrationRule$elasti !== void 0 && _migrationRule$elasti.id) && migrationRule.translation_result === _constants.MigrationTranslationResult.FULL;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 297,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 298,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      disabled: !canMigrationRuleBeInstalled,
      onClick: () => {
        installSingleRule(migrationRule);
        closeRulePreview();
      },
      "data-test-subj": "installMigrationRuleFromFlyoutButton",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 299,
        columnNumber: 15
      }
    }, i18n.INSTALL_WITHOUT_ENABLING_BUTTON_LABEL)), (0, _utils.isMigrationPrebuiltRule)(migrationRule.elastic_rule) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 311,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      disabled: !canMigrationRuleBeInstalled,
      onClick: () => {
        installSingleRule(migrationRule, true);
        closeRulePreview();
      },
      fill: true,
      "data-test-subj": "installAndEnableMigrationRuleFromFlyoutButton",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 312,
        columnNumber: 17
      }
    }, i18n.INSTALL_AND_ENABLE_BUTTON_LABEL)));
  }, [installSingleRule, isRulesLoading]);
  const getMigrationRuleData = (0, _react.useCallback)(ruleId => {
    if (!isRulesLoading && migrationRules.length) {
      const migrationRule = migrationRules.find(item => item.id === ruleId);
      let matchedPrebuiltRule;
      let relatedIntegrations = [];
      if (migrationRule) {
        var _migrationRule$elasti2, _prebuiltRuleVersions, _migrationRule$elasti3;
        // Find matched prebuilt rule if any and prioritize its installed version
        const prebuiltRuleId = (_migrationRule$elasti2 = migrationRule.elastic_rule) === null || _migrationRule$elasti2 === void 0 ? void 0 : _migrationRule$elasti2.prebuilt_rule_id;
        const prebuiltRuleVersions = prebuiltRuleId ? prebuiltRules[prebuiltRuleId] : undefined;
        matchedPrebuiltRule = (_prebuiltRuleVersions = prebuiltRuleVersions === null || prebuiltRuleVersions === void 0 ? void 0 : prebuiltRuleVersions.current) !== null && _prebuiltRuleVersions !== void 0 ? _prebuiltRuleVersions : prebuiltRuleVersions === null || prebuiltRuleVersions === void 0 ? void 0 : prebuiltRuleVersions.target;
        const integrationIds = (_migrationRule$elasti3 = migrationRule.elastic_rule) === null || _migrationRule$elasti3 === void 0 ? void 0 : _migrationRule$elasti3.integration_ids;
        if (integrations && integrationIds) {
          relatedIntegrations = integrationIds.map(integrationId => integrations[integrationId]).filter(integration => integration != null);
        }
      }
      return {
        migrationRule,
        matchedPrebuiltRule,
        relatedIntegrations,
        isIntegrationsLoading
      };
    }
  }, [integrations, isIntegrationsLoading, isRulesLoading, prebuiltRules, migrationRules]);
  const {
    migrationRuleDetailsFlyout: rulePreviewFlyout,
    openMigrationRuleDetails: openRulePreview
  } = (0, _use_migration_rule_preview_flyout.useMigrationRuleDetailsFlyout)({
    isLoading: isRulesLoading,
    getMigrationRuleData,
    ruleActionsFactory
  });
  const rulesColumns = (0, _use_migration_rules_table_columns.useMigrationRulesTableColumns)({
    disableActions: isTableLoading,
    openMigrationRuleDetails: openRulePreview,
    installMigrationRule: installSingleRule,
    getMigrationRuleData
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, reprocessMigrationModal, !isStatsLoading && (translationStats === null || translationStats === void 0 ? void 0 : translationStats.rules.total) && /*#__PURE__*/_react.default.createElement(_translation_guide.SiemTranslatedRulesTour, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 381,
      columnNumber: 62
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonLoading, {
    "data-test-subj": "migrationRulesTableSkeleton",
    isLoading: isStatsLoading,
    loadingContent: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonTitle, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 388,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 389,
        columnNumber: 15
      }
    })),
    loadedContent: !(translationStats !== null && translationStats !== void 0 && translationStats.rules.total) ? /*#__PURE__*/_react.default.createElement(_components.EmptyMigration, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 394,
        columnNumber: 15
      }
    }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      "data-test-subj": "siemMigrationsRulesTable",
      gutterSize: "m",
      justifyContent: "flexEnd",
      wrap: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 397,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 403,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_components.SearchField, {
      initialValue: searchTerm,
      onSearch: handleOnSearch,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 404,
        columnNumber: 21
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 406,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_filters.MigrationRulesFilter, {
      filterOptions: filterOptions,
      onFilterOptionsChanged: setFilterOptions,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 407,
        columnNumber: 21
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 412,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_bulk_actions.BulkActions, {
      isTableLoading: isRulesLoading,
      translationStats: translationStats,
      selectedRules: selectedMigrationRules,
      setMissingIndexPatternFlyoutOpen: openMissingIndexPatternFlyout,
      installTranslatedRule: installTranslatedRules,
      installSelectedRule: installSelectedRule,
      reprocessFailedRules: showReprocessMigrationModal,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 413,
        columnNumber: 21
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 424,
        columnNumber: 17
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 425,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 426,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBar, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 427,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBarSection, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 428,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBarGroup, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 429,
        columnNumber: 25
      }
    }, /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBarText, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 430,
        columnNumber: 27
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.siemMigrations.rules.table.showingPageOfTotalLabel",
      defaultMessage: "Showing {pageIndex} - {pageSize} of {total, plural, one {# rule} other {# rules}} {pipe} Selected {selectedRulesAmount, plural, one {# rule} other {# rules}}",
      values: {
        pageIndex: pagination.pageIndex * ((_pagination$pageSize = pagination.pageSize) !== null && _pagination$pageSize !== void 0 ? _pagination$pageSize : 0) + 1,
        pageSize: (pagination.pageIndex + 1) * ((_pagination$pageSize2 = pagination.pageSize) !== null && _pagination$pageSize2 !== void 0 ? _pagination$pageSize2 : 0),
        total: pagination.totalItemCount,
        selectedRulesAmount: selectedMigrationRules.length || 0,
        pipe: '\u2000|\u2000'
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 431,
        columnNumber: 29
      }
    }))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
      loading: isTableLoading,
      items: migrationRules,
      pagination: pagination,
      sorting: sorting,
      onChange: onTableChange,
      selection: tableSelection,
      itemId: 'id',
      "data-test-subj": 'rules-translation-table',
      columns: rulesColumns,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 448,
        columnNumber: 17
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 383,
      columnNumber: 9
    }
  }), isMissingIndexPatternFlyoutOpen && /*#__PURE__*/_react.default.createElement(_update_index_pattern.UpdateIndexPatternForm, {
    onClose: closeMissingIndexPatternFlyout,
    onSubmit: onSubmitMissingIndexPattern,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 464,
      columnNumber: 11
    }
  }), rulePreviewFlyout);
});
MigrationRulesTable.displayName = 'MigrationRulesTable';