"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MigrationReadyPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _constants = require("../../../../../common/siem_migrations/constants");
var _centered_loading_spinner = require("../../../../common/components/centered_loading_spinner");
var _use_kibana = require("../../../../common/lib/kibana/use_kibana");
var _components = require("../../../common/components");
var i18n = _interopRequireWildcard(require("./translations"));
var _panel_text = require("../../../../common/components/panel_text");
var _use_get_missing_resources = require("../../../common/hooks/use_get_missing_resources");
var _start_translation_button = require("../../../common/components/start_translation_button");
var _use_start_rules_migration_modal = require("../../hooks/use_start_rules_migration_modal");
var _use_start_migration = require("../../logic/use_start_migration");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/siem_migrations/rules/components/migration_status_panels/migration_ready_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MigrationReadyPanel = exports.MigrationReadyPanel = /*#__PURE__*/_react.default.memo(({
  migrationStats
}) => {
  var _migrationStats$last_2, _migrationStats$last_3;
  const {
    openFlyout
  } = (0, _components.useMigrationDataInputContext)();
  const {
    telemetry
  } = (0, _use_kibana.useKibana)().services.siemMigrations.rules;
  const [missingResources, setMissingResources] = _react.default.useState([]);
  const {
    getMissingResources,
    isLoading
  } = (0, _use_get_missing_resources.useGetMissingResources)('rule', setMissingResources);
  (0, _react.useEffect)(() => {
    getMissingResources(migrationStats.id);
  }, [getMissingResources, migrationStats.id]);
  const onOpenFlyout = (0, _react.useCallback)(() => {
    openFlyout(migrationStats);
    telemetry.reportSetupMigrationOpenResources({
      migrationId: migrationStats.id,
      missingResourcesCount: missingResources.length
    });
  }, [openFlyout, migrationStats, telemetry, missingResources.length]);
  const isStopped = (0, _react.useMemo)(() => migrationStats.status === _constants.SiemMigrationTaskStatus.STOPPED, [migrationStats.status]);
  const migrationPanelDescription = (0, _react.useMemo)(() => {
    var _migrationStats$last_;
    if ((_migrationStats$last_ = migrationStats.last_execution) !== null && _migrationStats$last_ !== void 0 && _migrationStats$last_.error) {
      return i18n.RULE_MIGRATION_ERROR_DESCRIPTION(migrationStats.items.total);
    }
    if (isStopped) {
      return i18n.RULE_MIGRATION_STOPPED_DESCRIPTION(migrationStats.items.total);
    }
    return i18n.RULE_MIGRATION_READY_DESCRIPTION(migrationStats.items.total);
  }, [(_migrationStats$last_2 = migrationStats.last_execution) === null || _migrationStats$last_2 === void 0 ? void 0 : _migrationStats$last_2.error, migrationStats.items.total, isStopped]);
  const {
    startMigration,
    isLoading: isStarting
  } = (0, _use_start_migration.useStartMigration)();
  const onStartMigrationWithSettings = (0, _react.useCallback)(settings => {
    startMigration(migrationStats.id, undefined, settings);
  }, [migrationStats.id, startMigration]);
  const {
    modal: startMigrationModal,
    showModal: showStartMigrationModal
  } = (0, _use_start_rules_migration_modal.useStartRulesMigrationModal)({
    type: 'start',
    migrationStats,
    onStartMigrationWithSettings
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, startMigrationModal, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    paddingSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "m",
    alignItems: "flexEnd",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_components.MigrationPanelTitle, {
    migrationStats: migrationStats,
    migrationType: "rule",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_panel_text.PanelText, {
    "data-test-subj": "ruleMigrationDescription",
    size: "s",
    subdued: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 19
    }
  }, migrationPanelDescription), !isLoading && missingResources.length > 0 && /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 21
    }
  }, " ", i18n.RULE_MIGRATION_READY_MISSING_RESOURCES))))), isLoading ? /*#__PURE__*/_react.default.createElement(_centered_loading_spinner.CenteredLoadingSpinner, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 13
    }
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, missingResources.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "ruleMigrationMissingResourcesButton",
    "aria-label": i18n.RULE_MIGRATION_UPLOAD_MISSING_RESOURCES_TITLE,
    iconType: "download",
    iconSide: "right",
    onClick: onOpenFlyout,
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 19
    }
  }, i18n.RULE_MIGRATION_UPLOAD_BUTTON)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_start_translation_button.StartTranslationButton, {
    migrationId: migrationStats.id,
    isStopped: isStopped,
    startMigration: isStopped ? startMigration : showStartMigrationModal,
    isStarting: isStarting,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 17
    }
  })))), ((_migrationStats$last_3 = migrationStats.last_execution) === null || _migrationStats$last_3 === void 0 ? void 0 : _migrationStats$last_3.error) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_components.MigrationsLastError, {
    message: migrationStats.last_execution.error,
    migrationType: "rule",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 13
    }
  }))));
});
MigrationReadyPanel.displayName = 'MigrationReadyPanel';