"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.links = void 0;
var _i18n = require("@kbn/i18n");
var _constants = require("@kbn/security-solution-features/constants");
var _constants2 = require("../../common/constants");
var _dashboards = require("../common/icons/dashboards");
var _rules = require("../common/icons/rules");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const subLinks = [{
  id: _constants2.SecurityPageName.siemMigrationsRules,
  title: _i18n.i18n.translate('xpack.securitySolution.appLinks.automaticMigrationRules.title', {
    defaultMessage: 'Translated rules'
  }),
  description: _i18n.i18n.translate('xpack.securitySolution.appLinks.siemMigrationsRules.description', {
    defaultMessage: 'Migrate your SIEM rules to Elastic using AI powered Automatic migration.'
  }),
  landingIcon: _rules.IconRules,
  path: _constants2.SIEM_MIGRATIONS_RULES_PATH,
  capabilities: [[`${_constants2.SECURITY_FEATURE_ID}.show`, `${_constants.SIEM_MIGRATIONS_FEATURE_ID}.all`]],
  skipUrlState: true,
  hideTimeline: true,
  hideWhenExperimentalKey: 'siemMigrationsDisabled'
}, {
  id: _constants2.SecurityPageName.siemMigrationsDashboards,
  title: _i18n.i18n.translate('xpack.securitySolution.appLinks.automaticMigrationDashboards.title', {
    defaultMessage: 'Translated dashboards'
  }),
  description: _i18n.i18n.translate('xpack.securitySolution.appLinks.siemMigrationsDashboards.description', {
    defaultMessage: 'Migrate your dashboards to Elastic using AI powered Automatic migration.'
  }),
  landingIcon: _dashboards.IconDashboards,
  path: _constants2.SIEM_MIGRATIONS_DASHBOARDS_PATH,
  capabilities: [[`${_constants2.SECURITY_FEATURE_ID}.show`, `${_constants.SIEM_MIGRATIONS_FEATURE_ID}.all`]],
  skipUrlState: true,
  hideTimeline: true,
  hideWhenExperimentalKey: 'siemMigrationsDisabled',
  experimentalKey: 'automaticDashboardsMigration',
  isBeta: true,
  betaOptions: {
    text: _i18n.i18n.translate('xpack.securitySolution.appLinks.siemMigrationsDashboards.badge', {
      defaultMessage: 'Technical Preview'
    })
  }
}];
const links = exports.links = {
  id: _constants2.SecurityPageName.siemMigrationsLanding,
  title: _i18n.i18n.translate('xpack.securitySolution.appLinks.automaticMigrations.title', {
    defaultMessage: 'Migrations'
  }),
  path: _constants2.SIEM_MIGRATIONS_LANDING_PATH,
  capabilities: [[`${_constants2.SECURITY_FEATURE_ID}.show`, `${_constants.SIEM_MIGRATIONS_FEATURE_ID}.all`]],
  globalSearchKeywords: [_i18n.i18n.translate('xpack.securitySolution.appLinks.migrations', {
    defaultMessage: 'Migrations'
  })],
  links: subLinks,
  skipUrlState: true,
  categories: [{
    label: _i18n.i18n.translate('xpack.securitySolution.appLinks.category.automaticMigrations', {
      defaultMessage: 'Automatic migrations'
    }),
    linkIds: [_constants2.SecurityPageName.siemMigrationsRules, _constants2.SecurityPageName.siemMigrationsDashboards]
  }]
};