"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StartMigrationModal = exports.DATA_TEST_SUBJ_PREFIX = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _deeplinksSecurity = require("@kbn/deeplinks-security");
var _securitySolutionConnectors = require("@kbn/security-solution-connectors");
var _use_ai_connectors = require("../../../../common/hooks/use_ai_connectors");
var _kibana = require("../../../../common/lib/kibana");
var _constants = require("../../../../onboarding/constants");
var _links = require("../../../../common/components/links");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/siem_migrations/common/components/start_migration_modal/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DATA_TEST_SUBJ_PREFIX = exports.DATA_TEST_SUBJ_PREFIX = 'startMigrationModal';
const StartMigrationModal = exports.StartMigrationModal = /*#__PURE__*/_react.default.memo(({
  title,
  description,
  defaultSettings = {},
  onClose: closeModal,
  onStartMigrationWithSettings: startMigrationWithSettings,
  additionalSettings
}) => {
  var _aiConnectors$;
  const {
    connectorId
  } = defaultSettings;
  const {
    siemMigrations,
    settings
  } = (0, _kibana.useKibana)().services;
  const {
    aiConnectors,
    isLoading
  } = (0, _use_ai_connectors.useAIConnectors)();
  const [selectedConnectorId, setSelectedConnectorId] = (0, _react.useState)(
  // Both `siemMigrations.rules` and `siemMigrations.dashboards` store connector using the same key,
  // that is why it is does not matter which one we use here to get access to it.
  connectorId || siemMigrations.rules.connectorIdStorage.get() || ((_aiConnectors$ = aiConnectors[0]) === null || _aiConnectors$ === void 0 ? void 0 : _aiConnectors$.id));
  const startMigrationModalTitleId = (0, _eui.useGeneratedHtmlId)();
  const getSecuritySolutionLinkProps = (0, _links.useGetSecuritySolutionLinkProps)();
  const {
    onClick: onClickSetupAIConnector,
    href: setupAIConnectorLink
  } = getSecuritySolutionLinkProps({
    deepLinkId: _deeplinksSecurity.SecurityPageName.landing,
    path: `${_constants.OnboardingTopicId.siemMigrations}#${_constants.OnboardingCardId.siemMigrationsAiConnectors}`
  });
  const onStartMigrationWithSettings = (0, _react.useCallback)(e => {
    e.preventDefault();
    if (!selectedConnectorId) {
      return;
    }
    startMigrationWithSettings({
      connectorId: selectedConnectorId
    });
    closeModal();
  }, [startMigrationWithSettings, selectedConnectorId, closeModal]);
  const errors = (0, _react.useMemo)(() => {
    const allErrors = [];
    if (!selectedConnectorId) {
      allErrors.push(/*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.siemMigrations.startMigrationModal.connectorRequiredError",
        defaultMessage: "An AI connector is required to start the translation.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 103,
          columnNumber: 11
        }
      }));
    }
    return allErrors;
  }, [selectedConnectorId]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiOutsideClickDetector, {
    onOutsideClick: closeModal,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    "aria-labelledby": startMigrationModalTitleId,
    onClose: closeModal,
    "data-test-subj": DATA_TEST_SUBJ_PREFIX,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    "data-test-subj": `${DATA_TEST_SUBJ_PREFIX}-Title`,
    id: startMigrationModalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 13
    }
  }, title)), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": `${DATA_TEST_SUBJ_PREFIX}-Description`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 15
    }
  }, description)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "form",
    onSubmit: onStartMigrationWithSettings,
    "data-test-subj": `${DATA_TEST_SUBJ_PREFIX}-Form`,
    isInvalid: !selectedConnectorId,
    error: errors,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: i18n.START_MIGRATION_MODAL_AI_CONNECTOR_LABEL,
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.siemMigrations.reprocessFailedDialog.connectorHelpText",
      defaultMessage: 'To set up other LLM connectors, visit {link}.',
      values: {
        link:
        /*#__PURE__*/
        /* eslint-disable-next-line @elastic/eui/href-or-on-click */
        _react.default.createElement(_eui.EuiLink, {
          href: setupAIConnectorLink,
          onClick: onClickSetupAIConnector,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 148,
            columnNumber: 25
          }
        }, i18n.START_MIGRATION_MODAL_SETUP_NEW_AI_CONNECTOR_HELP_TEXT)
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 142,
        columnNumber: 19
      }
    }),
    isInvalid: !selectedConnectorId,
    "aria-required": true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_securitySolutionConnectors.ConnectorSelector, {
    connectors: aiConnectors,
    selectedId: selectedConnectorId,
    onChange: setSelectedConnectorId,
    isInvalid: !selectedConnectorId,
    isLoading: isLoading,
    mode: 'combobox',
    settings: settings,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 17
    }
  })), additionalSettings && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 38
    }
  }, additionalSettings), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "aria-label": i18n.START_MIGRATION_MODAL_CANCEL,
    onClick: closeModal,
    "data-test-subj": `${DATA_TEST_SUBJ_PREFIX}-Cancel`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 19
    }
  }, i18n.START_MIGRATION_MODAL_CANCEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    type: "submit",
    "data-test-subj": `${DATA_TEST_SUBJ_PREFIX}-Translate`,
    color: "primary",
    fill: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 19
    }
  }, i18n.START_MIGRATION_MODAL_TRANSLATE)))))));
});
StartMigrationModal.displayName = 'StartMigrationModal';