"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SideEffectContext = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * React context that provides 'side-effectors' which we need to mock during testing.
 */
const sideEffectors = {
  timestamp: () => Date.now(),
  requestAnimationFrame(...args) {
    return window.requestAnimationFrame(...args);
  },
  cancelAnimationFrame(...args) {
    return window.cancelAnimationFrame(...args);
  },
  ResizeObserver,
  writeTextToClipboard(text) {
    return navigator.clipboard.writeText(text);
  },
  getBoundingClientRect(element) {
    return element.getBoundingClientRect();
  }
};

/**
 * The default values are used in production, tests can provide mock values using `SideEffectSimulator`.
 */
const SideEffectContext = exports.SideEffectContext = /*#__PURE__*/(0, _react.createContext)(sideEffectors);