"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExecutiveSummary = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _constants = require("../../../../common/constants");
var _kibana = require("../../../common/lib/kibana");
var _cost_savings = require("./cost_savings");
var _metrics = require("./metrics");
var i18n = _interopRequireWildcard(require("./translations"));
var _time_saved = require("./time_saved");
var _filtering_rate = require("./filtering_rate");
var _threats_detected = require("./threats_detected");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/reports/components/ai_value/executive_summary.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ExecutiveSummary = ({
  attackAlertIds,
  minutesPerAlert,
  analystHourlyRate,
  hasAttackDiscoveries,
  isLoading,
  from,
  to,
  valueMetrics,
  valueMetricsCompare
}) => {
  const {
    uiSettings
  } = (0, _kibana.useKibana)().services;
  const [title, setTitle] = (0, _react.useState)(uiSettings.get(_constants.DEFAULT_VALUE_REPORT_TITLE));
  const updateTitle = (0, _react.useCallback)(newTitle => {
    uiSettings.set(_constants.DEFAULT_VALUE_REPORT_TITLE, newTitle);
    setTitle(newTitle);
  }, [uiSettings]);
  const onTitleChange = (0, _react.useCallback)(e => {
    updateTitle(e.target.value);
  }, [updateTitle]);
  const subtitle = (0, _react.useMemo)(() => {
    const fromDate = new Date(from);
    const toDate = new Date(to);
    const currentLocale = _i18n.i18n.getLocale();
    return `${fromDate.toLocaleDateString(currentLocale, {
      day: 'numeric',
      month: 'short',
      year: 'numeric'
    })} - ${toDate.toLocaleDateString(currentLocale, {
      day: 'numeric',
      month: 'short',
      year: 'numeric'
    })}`;
  }, [from, to]);
  const isSmall = (0, _eui.useIsWithinMaxBreakpoint)('m');
  const costSavings = (0, _react.useMemo)(() => (0, _metrics.formatDollars)(valueMetrics.costSavings), [valueMetrics.costSavings]);
  const timerangeAsDays = (0, _react.useMemo)(() => (0, _metrics.getTimeRangeAsDays)({
    from,
    to
  }), [from, to]);
  const {
    euiTheme: {
      size
    }
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "executiveSummaryContainer",
    css: (0, _react2.css)`
        border-radius: ${size.s};
        padding: ${size.base} ${size.xl};
        min-height: 200px;
      `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiInlineEditTitle, {
    className: "executiveSummaryTitle",
    "data-test-subj": "executiveSummaryTitle",
    size: "l",
    heading: "h1",
    inputAriaLabel: i18n.EDIT_TITLE,
    value: title,
    onChange: onTitleChange,
    onCancel: previousValue => {
      updateTitle(previousValue);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    "data-test-subj": "executiveSummaryDateRange",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 9
    }
  }, subtitle)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: isSmall ? 'column' : 'row',
    "data-test-subj": "executiveSummaryFlexGroup",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: (0, _react2.css)`
            min-width: 350px;
          `,
    "data-test-subj": "executiveSummaryMainInfo",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 13
    }
  }, isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 3,
    size: "s",
    isLoading: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 17
    }
  }) : hasAttackDiscoveries ? /*#__PURE__*/_react.default.createElement("p", {
    "data-test-subj": "executiveSummaryMessage",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 17
    }
  }, i18n.EXECUTIVE_SUMMARY_SUBTITLE, /*#__PURE__*/_react.default.createElement("strong", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 19
    }
  }, i18n.EXECUTIVE_SAVINGS_SUMMARY({
    costSavings,
    hoursSaved: (0, _metrics.formatThousands)(valueMetrics.hoursSaved)
  })), i18n.EXECUTIVE_SUMMARY_MAIN_TEXT({
    timeRange: timerangeAsDays,
    minutesPerAlert,
    analystRate: analystHourlyRate
  }), /*#__PURE__*/_react.default.createElement("br", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 19
    }
  }), /*#__PURE__*/_react.default.createElement("br", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 19
    }
  }), i18n.EXECUTIVE_SUMMARY_SECONDARY_TEXT) : /*#__PURE__*/_react.default.createElement("p", {
    "data-test-subj": "executiveSummaryNoAttacks",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 17
    }
  }, i18n.EXECUTIVE_MESSAGE_NO_ATTACKS)))), (isLoading || hasAttackDiscoveries) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: (0, _react2.css)`
              min-width: 300px;
              display: grid;
            `,
    grow: isSmall,
    "data-test-subj": "executiveSummarySideStats",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_cost_savings.CostSavings, {
    analystHourlyRate: analystHourlyRate,
    costSavings: valueMetrics.costSavings,
    costSavingsCompare: valueMetricsCompare.costSavings,
    minutesPerAlert: minutesPerAlert,
    from: from,
    to: to,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 13
    }
  }))), (isLoading || hasAttackDiscoveries) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: isSmall ? 'column' : 'row',
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: (0, _react2.css)`
                display: grid;
              `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_time_saved.TimeSaved, {
    minutesPerAlert: minutesPerAlert,
    hoursSaved: valueMetrics.hoursSaved,
    hoursSavedCompare: valueMetricsCompare.hoursSaved,
    from: from,
    to: to,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: (0, _react2.css)`
                display: grid;
              `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_filtering_rate.FilteringRate, {
    attackAlertIds: attackAlertIds,
    totalAlerts: valueMetrics.totalAlerts,
    filteredAlertsPerc: valueMetrics.filteredAlertsPerc,
    filteredAlertsPercCompare: valueMetricsCompare.filteredAlertsPerc,
    from: from,
    to: to,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: (0, _react2.css)`
                display: grid;
              `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 222,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_threats_detected.ThreatsDetected, {
    attackDiscoveryCount: valueMetrics.attackDiscoveryCount,
    attackDiscoveryCountCompare: valueMetricsCompare.attackDiscoveryCount,
    from: from,
    to: to,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 227,
      columnNumber: 15
    }
  })))));
};
exports.ExecutiveSummary = ExecutiveSummary;