"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HostAlertsTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _use_navigate_to_alerts_page_with_filters = require("../../../../common/hooks/use_navigate_to_alerts_page_with_filters");
var _formatted_number = require("../../../../common/components/formatted_number");
var _header_section = require("../../../../common/components/header_section");
var _hover_visibility_container = require("../../../../common/components/hover_visibility_container");
var _inspect = require("../../../../common/components/inspect");
var _last_updated_at = require("../../../../common/components/last_updated_at");
var _links = require("../../../../common/components/links");
var _query_toggle = require("../../../../common/containers/query_toggle");
var i18n = _interopRequireWildcard(require("../translations"));
var _utils = require("../utils");
var _use_host_alerts_items = require("./use_host_alerts_items");
var _cell_actions = require("../../../../common/components/cell_actions");
var _use_global_filter_query = require("../../../../common/hooks/use_global_filter_query");
var _model = require("../../../../sourcerer/store/model");
var _risk_color_palette = require("../../../../common/utils/risk_color_palette");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/overview/components/detection_response/host_alerts_table/host_alerts_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DETECTION_RESPONSE_HOST_SEVERITY_QUERY_ID = 'vulnerableHostsBySeverityQuery';
const HostAlertsTable = exports.HostAlertsTable = /*#__PURE__*/_react.default.memo(({
  signalIndexName
}) => {
  const openAlertsPageWithFilters = (0, _use_navigate_to_alerts_page_with_filters.useNavigateToAlertsPageWithFilters)();
  const {
    filterQuery
  } = (0, _use_global_filter_query.useGlobalFilterQuery)();
  const openHostInAlerts = (0, _react.useCallback)(({
    hostName,
    severity
  }) => openAlertsPageWithFilters([{
    title: i18n.OPEN_IN_ALERTS_TITLE_HOSTNAME,
    selectedOptions: [hostName],
    fieldName: 'host.name'
  }, ...(severity ? [{
    title: i18n.OPEN_IN_ALERTS_TITLE_SEVERITY,
    selectedOptions: [severity],
    fieldName: _ruleDataUtils.ALERT_SEVERITY
  }] : [])]), [openAlertsPageWithFilters]);
  const {
    toggleStatus,
    setToggleStatus
  } = (0, _query_toggle.useQueryToggle)(DETECTION_RESPONSE_HOST_SEVERITY_QUERY_ID);
  const {
    items,
    isLoading,
    updatedAt,
    pagination
  } = (0, _use_host_alerts_items.useHostAlertsItems)({
    skip: !toggleStatus,
    queryId: DETECTION_RESPONSE_HOST_SEVERITY_QUERY_ID,
    signalIndexName,
    filterQuery
  });
  const columns = useGetTableColumns(openHostInAlerts);
  return /*#__PURE__*/_react.default.createElement(_hover_visibility_container.HoverVisibilityContainer, {
    show: true,
    targetClassNames: [_inspect.BUTTON_CLASS],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    "data-test-subj": "severityHostAlertsPanel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_header_section.HeaderSection, {
    id: DETECTION_RESPONSE_HOST_SEVERITY_QUERY_ID,
    title: i18n.HOST_ALERTS_SECTION_TITLE,
    subtitle: /*#__PURE__*/_react.default.createElement(_last_updated_at.LastUpdatedAt, {
      updatedAt: updatedAt,
      isUpdating: isLoading,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 21
      }
    }),
    titleSize: "s",
    toggleQuery: setToggleStatus,
    toggleStatus: toggleStatus,
    tooltip: i18n.HOST_TOOLTIP,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 9
    }
  }), toggleStatus && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    items: items,
    columns: columns,
    loading: isLoading,
    "data-test-subj": "severityHostAlertsTable",
    noItemsMessage: /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      title: /*#__PURE__*/_react.default.createElement("h3", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 113,
          columnNumber: 40
        }
      }, i18n.NO_ALERTS_FOUND),
      titleSize: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 113,
        columnNumber: 17
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 13
    }
  }), pagination.pageCount > 1 && /*#__PURE__*/_react.default.createElement(_eui.EuiTablePagination, {
    "data-test-subj": "hostTablePaginator",
    activePage: pagination.currentPage,
    itemsPerPage: _utils.ITEMS_PER_PAGE,
    pageCount: pagination.pageCount,
    onChangePage: pagination.setPage,
    showPerPageOptions: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 15
    }
  }))));
});
HostAlertsTable.displayName = 'HostAlertsTable';
const useGetTableColumns = handleClick => {
  const severityColors = (0, _risk_color_palette.useRiskSeverityColors)();
  return (0, _react.useMemo)(() => [{
    field: 'hostName',
    name: i18n.HOST_ALERTS_HOSTNAME_COLUMN,
    'data-test-subj': 'hostSeverityAlertsTable-hostName',
    render: hostName => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      title: i18n.OPEN_HOST_DETAIL_TOOLTIP,
      content: hostName,
      anchorClassName: "eui-textTruncate",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 145,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_links.HostDetailsLink, {
      hostName: hostName,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 150,
        columnNumber: 13
      }
    }))
  }, {
    field: 'totalAlerts',
    name: i18n.ALERTS_TEXT,
    'data-test-subj': 'hostSeverityAlertsTable-totalAlerts',
    render: (totalAlerts, {
      hostName
    }) => /*#__PURE__*/_react.default.createElement(_cell_actions.SecurityCellActions, {
      data: {
        value: hostName,
        field: 'host.name'
      },
      mode: _cell_actions.CellActionsMode.HOVER_RIGHT,
      triggerId: _cell_actions.SecurityCellActionsTrigger.ALERTS_COUNT,
      sourcererScopeId: _model.SourcererScopeName.detections,
      metadata: {
        andFilters: [{
          field: 'kibana.alert.workflow_status',
          value: 'open'
        }]
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 159,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": "hostSeverityAlertsTable-totalAlertsLink",
      disabled: totalAlerts === 0,
      onClick: () => handleClick({
        hostName
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 171,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_formatted_number.FormattedCount, {
      count: totalAlerts,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 176,
        columnNumber: 15
      }
    })))
  }, {
    field: 'critical',
    name: i18n.STATUS_CRITICAL_LABEL,
    render: (count, {
      hostName
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
      "data-test-subj": "hostSeverityAlertsTable-critical",
      color: severityColors.critical,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 185,
        columnNumber: 11
      }
    }, count > 0 ? /*#__PURE__*/_react.default.createElement(_cell_actions.SecurityCellActions, {
      data: {
        value: hostName,
        field: 'host.name'
      },
      mode: _cell_actions.CellActionsMode.HOVER_RIGHT,
      triggerId: _cell_actions.SecurityCellActionsTrigger.ALERTS_COUNT,
      sourcererScopeId: _model.SourcererScopeName.detections,
      metadata: {
        andFilters: [{
          field: 'kibana.alert.severity',
          value: 'critical'
        }, {
          field: 'kibana.alert.workflow_status',
          value: 'open'
        }]
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 190,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": "hostSeverityAlertsTable-criticalLink",
      onClick: () => handleClick({
        hostName,
        severity: 'critical'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 205,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_formatted_number.FormattedCount, {
      count: count,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 209,
        columnNumber: 19
      }
    }))) : /*#__PURE__*/_react.default.createElement(_formatted_number.FormattedCount, {
      count: count,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 213,
        columnNumber: 15
      }
    }))
  }, {
    field: 'high',
    name: i18n.STATUS_HIGH_LABEL,
    render: (count, {
      hostName
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
      "data-test-subj": "hostSeverityAlertsTable-high",
      color: severityColors.high,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 222,
        columnNumber: 11
      }
    }, count > 0 ? /*#__PURE__*/_react.default.createElement(_cell_actions.SecurityCellActions, {
      data: {
        value: hostName,
        field: 'host.name'
      },
      mode: _cell_actions.CellActionsMode.HOVER_RIGHT,
      triggerId: _cell_actions.SecurityCellActionsTrigger.ALERTS_COUNT,
      sourcererScopeId: _model.SourcererScopeName.detections,
      metadata: {
        andFilters: [{
          field: 'kibana.alert.severity',
          value: 'high'
        }, {
          field: 'kibana.alert.workflow_status',
          value: 'open'
        }]
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 224,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: () => handleClick({
        hostName,
        severity: 'high'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 239,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_formatted_number.FormattedCount, {
      count: count,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 240,
        columnNumber: 19
      }
    }))) : /*#__PURE__*/_react.default.createElement(_formatted_number.FormattedCount, {
      count: count,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 244,
        columnNumber: 15
      }
    }))
  }, {
    field: 'medium',
    name: i18n.STATUS_MEDIUM_LABEL,
    render: (count, {
      hostName
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
      "data-test-subj": "hostSeverityAlertsTable-medium",
      color: severityColors.medium,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 253,
        columnNumber: 11
      }
    }, count > 0 ? /*#__PURE__*/_react.default.createElement(_cell_actions.SecurityCellActions, {
      data: {
        value: hostName,
        field: 'host.name'
      },
      mode: _cell_actions.CellActionsMode.HOVER_RIGHT,
      triggerId: _cell_actions.SecurityCellActionsTrigger.ALERTS_COUNT,
      sourcererScopeId: _model.SourcererScopeName.detections,
      metadata: {
        andFilters: [{
          field: 'kibana.alert.severity',
          value: 'medium'
        }, {
          field: 'kibana.alert.workflow_status',
          value: 'open'
        }]
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 255,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: () => handleClick({
        hostName,
        severity: 'medium'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 270,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_formatted_number.FormattedCount, {
      count: count,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 271,
        columnNumber: 19
      }
    }))) : /*#__PURE__*/_react.default.createElement(_formatted_number.FormattedCount, {
      count: count,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 275,
        columnNumber: 15
      }
    }))
  }, {
    field: 'low',
    name: i18n.STATUS_LOW_LABEL,
    render: (count, {
      hostName
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
      "data-test-subj": "hostSeverityAlertsTable-low",
      color: severityColors.low,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 284,
        columnNumber: 11
      }
    }, count > 0 ? /*#__PURE__*/_react.default.createElement(_cell_actions.SecurityCellActions, {
      data: {
        value: hostName,
        field: 'host.name'
      },
      mode: _cell_actions.CellActionsMode.HOVER_RIGHT,
      triggerId: _cell_actions.SecurityCellActionsTrigger.ALERTS_COUNT,
      sourcererScopeId: _model.SourcererScopeName.detections,
      metadata: {
        andFilters: [{
          field: 'kibana.alert.severity',
          value: 'low'
        }, {
          field: 'kibana.alert.workflow_status',
          value: 'open'
        }]
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 286,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: () => handleClick({
        hostName,
        severity: 'low'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 301,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_formatted_number.FormattedCount, {
      count: count,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 302,
        columnNumber: 19
      }
    }))) : /*#__PURE__*/_react.default.createElement(_formatted_number.FormattedCount, {
      count: count,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 306,
        columnNumber: 15
      }
    }))
  }], [handleClick, severityColors.critical, severityColors.high, severityColors.low, severityColors.medium]);
};