"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useOnboardingContext = exports.OnboardingContextProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kibana_react = require("../../common/lib/kibana/kibana_react");
var _use_license = require("../../common/hooks/use_license");
var _experimental_features_service = require("../../common/experimental_features_service");
var _capabilities = require("../../common/lib/capabilities");
var _config = require("../config");
var _onboarding_telemetry = require("./onboarding_telemetry");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/onboarding/components/onboarding_context.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const OnboardingContext = /*#__PURE__*/(0, _react.createContext)(null);
const OnboardingContextProvider = exports.OnboardingContextProvider = /*#__PURE__*/_react.default.memo(({
  children,
  spaceId
}) => {
  const config = useFilteredConfig();
  const telemetry = (0, _onboarding_telemetry.useOnboardingTelemetry)();
  const value = (0, _react.useMemo)(() => ({
    spaceId,
    telemetry,
    config
  }), [spaceId, telemetry, config]);
  return /*#__PURE__*/_react.default.createElement(OnboardingContext.Provider, {
    value: value,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 12
    }
  }, children);
});
OnboardingContextProvider.displayName = 'OnboardingContextProvider';
const useOnboardingContext = () => {
  const context = (0, _react.useContext)(OnboardingContext);
  if (!context) {
    throw new Error('No OnboardingContext found. Please wrap the application with OnboardingProvider');
  }
  return context;
};

/**
 * Hook that filters the config based on the user's capabilities, license and experimental features
 */
exports.useOnboardingContext = useOnboardingContext;
const useFilteredConfig = () => {
  const {
    capabilities
  } = (0, _kibana_react.useKibana)().services.application;
  const experimentalFeatures = _experimental_features_service.ExperimentalFeaturesService.get();
  const license = (0, _use_license.useLicense)();
  const isAvailable = (0, _react.useCallback)(item => {
    if (item.experimentalFlagRequired && !experimentalFeatures[item.experimentalFlagRequired]) {
      return false;
    }
    if (item.disabledExperimentalFlagRequired && experimentalFeatures[item.disabledExperimentalFlagRequired]) {
      return false;
    }
    if (item.licenseTypeRequired && !license.isAtLeast(item.licenseTypeRequired)) {
      return false;
    }
    if (item.capabilitiesRequired && !(0, _capabilities.hasCapabilities)(capabilities, item.capabilitiesRequired)) {
      return false;
    }
    return true;
  }, [license, capabilities, experimentalFeatures]);
  const filteredConfig = (0, _react.useMemo)(() => _config.onboardingConfig.reduce((filteredTopicConfigs, topicConfig) => {
    if (!isAvailable(topicConfig)) {
      return filteredTopicConfigs;
    }
    const filteredBody = topicConfig.body.reduce((filteredGroups, group) => {
      const filteredCards = group.cards.filter(isAvailable);
      if (filteredCards.length > 0) {
        filteredGroups.push({
          ...group,
          cards: filteredCards
        });
      }
      return filteredGroups;
    }, []);
    if (filteredBody.length > 0) {
      filteredTopicConfigs.set(topicConfig.id, {
        ...topicConfig,
        body: filteredBody
      });
    }
    return filteredTopicConfigs;
  }, new Map()), [isAvailable]);
  return filteredConfig;
};