"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OnboardingCardPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _classnames = _interopRequireDefault(require("classnames"));
var _reactKibanaContextTheme = require("@kbn/react-kibana-context-theme");
var _translations = require("./translations");
var _onboarding_card_panel = require("./onboarding_card_panel.styles");
var _use_delayed_visibility = require("./hooks/use_delayed_visibility");
var _onboarding_card_panel_badge = require("./onboarding_card_panel_badge");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/onboarding/components/onboarding_body/onboarding_card_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const OnboardingCardPanel = exports.OnboardingCardPanel = /*#__PURE__*/_react.default.memo(({
  id,
  title,
  icon,
  iconDark,
  badge,
  isExpanded,
  isComplete,
  onToggleExpanded,
  checkCompleteResult,
  children
}) => {
  var _checkCompleteResult$, _checkCompleteResult$2;
  const styles = (0, _onboarding_card_panel.useCardPanelStyles)();
  const cardPanelClassName = (0, _classnames.default)(styles, {
    'onboardingCardPanel-expanded': isExpanded,
    'onboardingCardPanel-completed': isComplete
  });
  const isDarkMode = (0, _reactKibanaContextTheme.useKibanaIsDarkMode)();
  const iconType = (0, _react.useMemo)(() => iconDark && isDarkMode ? iconDark : icon, [isDarkMode, iconDark, icon]);
  const isContentVisible = (0, _use_delayed_visibility.useDelayedVisibility)({
    isExpanded
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    id: id,
    color: "plain",
    grow: false,
    hasShadow: isExpanded,
    borderRadius: "m",
    paddingSize: "none",
    hasBorder: !isExpanded,
    className: cardPanelClassName,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    alignItems: "center",
    onClick: onToggleExpanded,
    className: "onboardingCardHeader",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: "onboardingCardIcon",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: iconType,
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    direction: "row",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    className: "onboardingCardHeaderTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 19
    }
  }, title))), badge && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_onboarding_card_panel_badge.OnboardingCardBadge, {
    badge: badge,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 19
    }
  })))), (_checkCompleteResult$ = checkCompleteResult === null || checkCompleteResult === void 0 ? void 0 : (_checkCompleteResult$2 = checkCompleteResult.additionalBadges) === null || _checkCompleteResult$2 === void 0 ? void 0 : _checkCompleteResult$2.map((additionalBadge, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    key: index,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 13
    }
  }, additionalBadge))) !== null && _checkCompleteResult$ !== void 0 ? _checkCompleteResult$ : null, isComplete && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    className: "onboardingCardHeaderCompleteBadge",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 15
    }
  }, (checkCompleteResult === null || checkCompleteResult === void 0 ? void 0 : checkCompleteResult.completeBadgeText) || _translations.CARD_COMPLETE_BADGE)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    color: "primary",
    size: "xs",
    iconType: isExpanded ? 'arrowUp' : 'arrowDown',
    "aria-label": (0, _translations.EXPAND_CARD_BUTTON_LABEL)(title),
    "aria-expanded": isExpanded,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement("div", {
    className: "onboardingCardContentWrapper",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "onboardingCardContent",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 11
    }
  }, isContentVisible ? children : null)));
});
OnboardingCardPanel.displayName = 'OnboardingCardPanel';