"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCardContentAssetPanelStyles = void 0;
var _css = require("@emotion/css");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useCardContentAssetPanelStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const shadowStyles = (0, _eui.useEuiShadow)('m');
  return (0, _css.css)`
    .cardSpacer {
      width: 48px;
    }
    .cardImage {
      width: 488px;
      height: 275px;
      iframe {
        border-radius: ${euiTheme.size.s};
        ${shadowStyles}
        overflor: hidden;
      }
      img {
        width: 100%;
        border-radius: ${euiTheme.size.s};
        ${shadowStyles}
      }
    }
  `;
};
exports.useCardContentAssetPanelStyles = useCardContentAssetPanelStyles;