"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TrustedDevicesForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _securitysolutionUtils = require("@kbn/securitysolution-utils");
var _formatted_error = require("../../../../components/formatted_error");
var _use_test_id_generator = require("../../../../hooks/use_test_id_generator");
var _artifacts = require("../../../../hooks/artifacts");
var _use_get_trusted_device_suggestions = require("../../hooks/use_get_trusted_device_suggestions");
var _effected_policy_select = require("../../../../components/effected_policy_select");
var _translations = require("../../../../common/translations");
var _translations2 = require("../translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/pages/trusted_devices/view/components/form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const OS_OPTIONS = [{
  label: _translations.OPERATING_SYSTEM_WINDOWS_AND_MAC,
  value: [_securitysolutionUtils.OperatingSystem.WINDOWS, _securitysolutionUtils.OperatingSystem.MAC]
}, {
  label: _translations.OS_TITLES[_securitysolutionUtils.OperatingSystem.WINDOWS],
  value: [_securitysolutionUtils.OperatingSystem.WINDOWS]
}, {
  label: _translations.OS_TITLES[_securitysolutionUtils.OperatingSystem.MAC],
  value: [_securitysolutionUtils.OperatingSystem.MAC]
}];
const DetailsSection = /*#__PURE__*/(0, _react.memo)(({
  mode,
  getTestId,
  item,
  handleNameChange,
  handleNameBlur,
  handleDescriptionChange,
  disabled,
  visitedFields,
  validationResult
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "xs",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 102,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement("h3", {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 103,
    columnNumber: 9
  }
}, _translations2.DETAILS_HEADER)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "xs",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 105,
    columnNumber: 7
  }
}), mode === 'create' && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s",
  "data-test-subj": getTestId('about'),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 107,
    columnNumber: 9
  }
}, /*#__PURE__*/_react.default.createElement("p", {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 108,
    columnNumber: 11
  }
}, _translations2.DETAILS_HEADER_DESCRIPTION)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "m",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 111,
    columnNumber: 7
  }
}), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
  label: _translations2.NAME_LABEL,
  fullWidth: true,
  "data-test-subj": getTestId('nameRow'),
  isInvalid: visitedFields.name && !!validationResult.errors.name,
  error: visitedFields.name ? validationResult.errors.name : undefined,
  helpText: visitedFields.name && validationResult.warnings.name ? validationResult.warnings.name[0] : undefined,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 113,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
  name: "name",
  value: item.name || '',
  onChange: handleNameChange,
  onBlur: handleNameBlur,
  fullWidth: true,
  maxLength: 256,
  "data-test-subj": getTestId('nameTextField'),
  disabled: disabled,
  isInvalid: visitedFields.name && !!validationResult.errors.name,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 125,
    columnNumber: 9
  }
})), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
  label: _translations2.DESCRIPTION_LABEL,
  fullWidth: true,
  "data-test-subj": getTestId('descriptionRow'),
  isInvalid: !!validationResult.errors.description,
  error: validationResult.errors.description,
  helpText: validationResult.warnings.description ? validationResult.warnings.description[0] : undefined,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 138,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
  isInvalid: !!validationResult.errors.description,
  name: "description",
  value: item.description || '',
  onChange: handleDescriptionChange,
  fullWidth: true,
  compressed: true,
  maxLength: 256,
  "data-test-subj": getTestId('descriptionField'),
  disabled: disabled,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 150,
    columnNumber: 9
  }
}))));
DetailsSection.displayName = 'DetailsSection';
const ConditionsSection = /*#__PURE__*/(0, _react.memo)(({
  getTestId,
  selectedOs,
  handleOsChange,
  currentEntry,
  handleFieldChange,
  handleOperatorChange,
  handleValueChange,
  handleValueBlur,
  disabled,
  visitedFields,
  validationResult
}) => {
  // Get field options based on selected OS
  const availableFieldOptions = (0, _react.useMemo)(() => {
    return getFieldOptionsForOs(selectedOs);
  }, [selectedOs]);

  // Load suggestions when field changes - useQuery handles race conditions automatically
  const {
    data: suggestions = [],
    isLoading: isLoadingSuggestions
  } = (0, _use_get_trusted_device_suggestions.useGetTrustedDeviceSuggestions)({
    field: currentEntry.field || '',
    enabled: !disabled
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 11
    }
  }, _translations2.CONDITIONS_HEADER)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 9
    }
  }, _translations2.CONDITIONS_HEADER_DESCRIPTION), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 212,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _translations2.SELECT_OS_LABEL,
    fullWidth: true,
    "data-test-subj": getTestId('osRow'),
    isInvalid: visitedFields.os && !!validationResult.errors.os,
    error: visitedFields.os ? validationResult.errors.os : undefined,
    helpText: visitedFields.os && validationResult.warnings.os ? validationResult.warnings.os[0] : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 214,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    isInvalid: visitedFields.os && !!validationResult.errors.os,
    placeholder: _translations2.OS_OPTIONS_PLACEHOLDER,
    singleSelection: {
      asPlainText: true
    },
    options: OS_OPTIONS,
    selectedOptions: OS_OPTIONS.filter(option => JSON.stringify(option.value) === JSON.stringify(selectedOs)),
    onChange: handleOsChange,
    isClearable: false,
    "data-test-subj": getTestId('osSelectField'),
    isDisabled: disabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 226,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    "data-test-subj": getTestId('conditionsRow'),
    isInvalid: visitedFields.entries && !!validationResult.errors.entries,
    error: visitedFields.entries ? validationResult.errors.entries : undefined,
    helpText: visitedFields.entries && validationResult.warnings.entries ? validationResult.warnings.entries[0] : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 241,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 252,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 253,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: "Field",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 254,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    options: availableFieldOptions,
    valueOfSelected: currentEntry.field || _securitysolutionUtils.TrustedDeviceConditionEntryField.DEVICE_ID,
    onChange: handleFieldChange,
    "data-test-subj": getTestId('fieldSelect'),
    disabled: disabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 255,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 264,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: "Operator",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 265,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    options: OPERATOR_OPTIONS,
    valueOfSelected: currentEntry.type === 'match' ? 'is' : 'match',
    onChange: handleOperatorChange,
    "data-test-subj": getTestId('operatorSelect'),
    disabled: disabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 266,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 275,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: "Value",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 276,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    placeholder: "Enter or select value",
    singleSelection: {
      asPlainText: true
    },
    options: suggestions.map(suggestion => ({
      label: suggestion
    })),
    selectedOptions: 'value' in currentEntry && currentEntry.value ? [{
      label: String(currentEntry.value)
    }] : [],
    onChange: handleValueChange,
    onBlur: handleValueBlur,
    onCreateOption: searchValue => {
      handleValueChange([{
        label: searchValue
      }]);
    },
    isLoading: isLoadingSuggestions,
    "data-test-subj": getTestId('valueField'),
    isDisabled: disabled,
    isClearable: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 277,
      columnNumber: 17
    }
  }))))));
});
ConditionsSection.displayName = 'ConditionsSection';
const getFieldOptionsForOs = osTypes => {
  const allFields = [{
    value: _securitysolutionUtils.TrustedDeviceConditionEntryField.DEVICE_ID,
    inputDisplay: _translations2.CONDITION_FIELD_TITLE[_securitysolutionUtils.TrustedDeviceConditionEntryField.DEVICE_ID]
  }, {
    value: _securitysolutionUtils.TrustedDeviceConditionEntryField.DEVICE_TYPE,
    inputDisplay: _translations2.CONDITION_FIELD_TITLE[_securitysolutionUtils.TrustedDeviceConditionEntryField.DEVICE_TYPE]
  }, {
    value: _securitysolutionUtils.TrustedDeviceConditionEntryField.HOST,
    inputDisplay: _translations2.CONDITION_FIELD_TITLE[_securitysolutionUtils.TrustedDeviceConditionEntryField.HOST]
  }, {
    value: _securitysolutionUtils.TrustedDeviceConditionEntryField.MANUFACTURER,
    inputDisplay: _translations2.CONDITION_FIELD_TITLE[_securitysolutionUtils.TrustedDeviceConditionEntryField.MANUFACTURER]
  }, {
    value: _securitysolutionUtils.TrustedDeviceConditionEntryField.MANUFACTURER_ID,
    inputDisplay: _translations2.CONDITION_FIELD_TITLE[_securitysolutionUtils.TrustedDeviceConditionEntryField.MANUFACTURER_ID]
  }, {
    value: _securitysolutionUtils.TrustedDeviceConditionEntryField.PRODUCT_ID,
    inputDisplay: _translations2.CONDITION_FIELD_TITLE[_securitysolutionUtils.TrustedDeviceConditionEntryField.PRODUCT_ID]
  }, {
    value: _securitysolutionUtils.TrustedDeviceConditionEntryField.PRODUCT_NAME,
    inputDisplay: _translations2.CONDITION_FIELD_TITLE[_securitysolutionUtils.TrustedDeviceConditionEntryField.PRODUCT_NAME]
  }];
  if ((0, _securitysolutionUtils.isTrustedDeviceFieldAvailableForOs)(_securitysolutionUtils.TrustedDeviceConditionEntryField.USERNAME, osTypes)) {
    allFields.push({
      value: _securitysolutionUtils.TrustedDeviceConditionEntryField.USERNAME,
      inputDisplay: _translations2.CONDITION_FIELD_TITLE[_securitysolutionUtils.TrustedDeviceConditionEntryField.USERNAME]
    });
  }
  return allFields;
};
const OPERATOR_OPTIONS = [{
  value: 'is',
  inputDisplay: _translations2.OPERATOR_TITLES.is
}, {
  value: 'match',
  inputDisplay: _translations2.OPERATOR_TITLES.matches
}];
const TrustedDevicesForm = exports.TrustedDevicesForm = /*#__PURE__*/(0, _react.memo)(({
  item,
  onChange,
  mode = 'create',
  disabled = false,
  error: submitError
}) => {
  const [hasUserSelectedOs, setHasUserSelectedOs] = (0, _react.useState)(false);
  const [hasFormChanged, setHasFormChanged] = (0, _react.useState)(false);
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)('trustedDevices-form');
  const [visitedFields, setVisitedFields] = (0, _react.useState)({});
  const [validationResult, setValidationResult] = (0, _react.useState)({
    isValid: false,
    errors: {},
    warnings: {}
  });

  // For new TD items, ensure we start with the correct OS types
  const currentItem = (0, _react.useMemo)(() => {
    var _item$os_types, _item$name;
    if (mode === 'create' && ((_item$os_types = item.os_types) === null || _item$os_types === void 0 ? void 0 : _item$os_types.length) === 1 && item.os_types[0] === 'windows' && !((_item$name = item.name) !== null && _item$name !== void 0 && _item$name.trim()) && !hasUserSelectedOs // Don't override if user has explicitly selected an OS
    ) {
      return {
        ...item,
        os_types: [_securitysolutionUtils.OperatingSystem.WINDOWS, _securitysolutionUtils.OperatingSystem.MAC]
      };
    }
    return item;
  }, [item, mode, hasUserSelectedOs]);
  const showAssignmentSection = (0, _artifacts.useCanAssignArtifactPerPolicy)(currentItem, mode, hasFormChanged, 'enterprise');
  const updateVisitedFields = (0, _react.useCallback)(updates => {
    setVisitedFields(prev => ({
      ...prev,
      ...updates
    }));
  }, []);
  const validateForm = (0, _react.useCallback)(formData => {
    var _formData$name, _formData$os_types, _formData$os_types$le, _formData$os_types2;
    const errors = {};
    const warnings = {};

    // Name validation
    if (!((_formData$name = formData.name) !== null && _formData$name !== void 0 && _formData$name.trim())) {
      errors.name = [_translations2.INPUT_ERRORS.name];
    } else if (formData.name.trim().length > 256) {
      errors.name = [_translations2.INPUT_ERRORS.nameMaxLength];
    }

    // Description validation
    if (formData.description && formData.description.length > 256) {
      errors.description = [_translations2.INPUT_ERRORS.descriptionMaxLength];
    }

    // OS validation
    if (!((_formData$os_types = formData.os_types) !== null && _formData$os_types !== void 0 && _formData$os_types.length)) {
      errors.os = [_translations2.INPUT_ERRORS.osRequired];
    }

    // Condition validation (backend schema: entries minSize: 1, value length > 0)
    const hasOsSelected = ((_formData$os_types$le = (_formData$os_types2 = formData.os_types) === null || _formData$os_types2 === void 0 ? void 0 : _formData$os_types2.length) !== null && _formData$os_types$le !== void 0 ? _formData$os_types$le : 0) > 0;
    const hasVisitedEntries = visitedFields.entries;
    if (hasOsSelected || hasVisitedEntries) {
      var _formData$entries, _formData$entries2;
      const entry = (_formData$entries = formData.entries) === null || _formData$entries === void 0 ? void 0 : _formData$entries[0];
      if (!((_formData$entries2 = formData.entries) !== null && _formData$entries2 !== void 0 && _formData$entries2.length) || !entry) {
        errors.entries = [_translations2.INPUT_ERRORS.entriesAtLeastOne];
      } else if ('value' in entry) {
        // Handle string values (matching backend schema: length > 0)
        if (typeof entry.value === 'string') {
          if (!entry.value.trim()) {
            errors.entries = [_translations2.INPUT_ERRORS.entryValueEmpty];
          }

          // Wildcard validation for "match" operator
          if (entry.type === 'wildcard' && entry.value.includes('**')) {
            warnings.entries = [_translations2.VALIDATION_WARNINGS.performanceWildcard];
          }
        }
        // Handle array values
        else if (Array.isArray(entry.value) && (!entry.value || entry.value.length === 0)) {
          errors.entries = [_translations2.INPUT_ERRORS.entryValueEmpty];
        }
      }
    }
    return {
      isValid: Object.keys(errors).length === 0,
      errors,
      warnings
    };
  }, [visitedFields]);
  const updateField = (0, _react.useCallback)((field, value) => {
    const updatedItem = {
      ...currentItem,
      [field]: value
    };
    const validation = validateForm(updatedItem);
    setValidationResult(validation);
    setHasFormChanged(true);
    onChange({
      item: updatedItem,
      isValid: validation.isValid
    });
  }, [currentItem, onChange, validateForm]);
  const handleNameChange = (0, _react.useCallback)(event => {
    updateField('name', event.target.value);
  }, [updateField]);
  const handleNameBlur = (0, _react.useCallback)(event => {
    updateVisitedFields({
      ...visitedFields,
      name: true
    });
  }, [visitedFields, updateVisitedFields]);
  const handleDescriptionChange = (0, _react.useCallback)(event => {
    updateField('description', event.target.value);
  }, [updateField]);
  const handleOsChange = (0, _react.useCallback)(selectedOptions => {
    var _selectedOptions$, _currentItem$entries;
    const osTypes = ((_selectedOptions$ = selectedOptions[0]) === null || _selectedOptions$ === void 0 ? void 0 : _selectedOptions$.value) || [];
    const currentEntry = (_currentItem$entries = currentItem.entries) === null || _currentItem$entries === void 0 ? void 0 : _currentItem$entries[0];

    // Mark that user has explicitly selected an OS
    setHasUserSelectedOs(true);
    setHasFormChanged(true);
    let fieldToUse = (currentEntry === null || currentEntry === void 0 ? void 0 : currentEntry.field) || _securitysolutionUtils.TrustedDeviceConditionEntryField.DEVICE_ID;
    let shouldResetValue = false;

    // If current field is USERNAME but USERNAME is not available for new OS selection, reset to DEVICE_ID
    if (fieldToUse === _securitysolutionUtils.TrustedDeviceConditionEntryField.USERNAME && !(0, _securitysolutionUtils.isTrustedDeviceFieldAvailableForOs)(_securitysolutionUtils.TrustedDeviceConditionEntryField.USERNAME, osTypes)) {
      fieldToUse = _securitysolutionUtils.TrustedDeviceConditionEntryField.DEVICE_ID;
      shouldResetValue = true;
    }
    const updatedItem = {
      ...currentItem,
      os_types: osTypes,
      entries: [{
        field: fieldToUse,
        operator: 'included',
        type: 'match',
        value: shouldResetValue ? '' : currentEntry && 'value' in currentEntry ? String(currentEntry.value || '') : ''
      }]
    };
    const validation = validateForm(updatedItem);
    updateVisitedFields({
      ...visitedFields,
      os: true
    });
    onChange({
      item: updatedItem,
      isValid: validation.isValid
    });
  }, [currentItem, onChange, validateForm, updateVisitedFields, visitedFields]);
  const updateConditionField = (0, _react.useCallback)(updates => {
    var _currentItem$entries2;
    const currentEntry = ((_currentItem$entries2 = currentItem.entries) === null || _currentItem$entries2 === void 0 ? void 0 : _currentItem$entries2[0]) || {
      field: _securitysolutionUtils.TrustedDeviceConditionEntryField.DEVICE_ID,
      operator: 'included',
      type: 'match',
      value: ''
    };
    const updatedEntry = {
      ...currentEntry,
      ...updates
    };
    const updatedItem = {
      ...currentItem,
      entries: [updatedEntry]
    };
    const validation = validateForm(updatedItem);
    setValidationResult(validation);
    setHasFormChanged(true);
    onChange({
      item: updatedItem,
      isValid: validation.isValid
    });
  }, [currentItem, onChange, validateForm, setValidationResult]);
  const handleFieldChange = (0, _react.useCallback)(value => {
    updateConditionField({
      field: value
    });
  }, [updateConditionField]);
  const handleOperatorChange = (0, _react.useCallback)(value => {
    const type = value === 'is' ? 'match' : 'wildcard';
    updateConditionField({
      type
    });
  }, [updateConditionField]);
  const handleValueChange = (0, _react.useCallback)(options => {
    const value = options.length > 0 ? options[0].label : '';
    updateConditionField({
      value
    });
  }, [updateConditionField]);
  const handleValueBlur = (0, _react.useCallback)(() => {
    updateVisitedFields({
      ...visitedFields,
      entries: true
    });
  }, [visitedFields, updateVisitedFields]);
  const handlePolicyChange = (0, _react.useCallback)(updatedItem => {
    const validation = validateForm(updatedItem);
    setHasFormChanged(true);
    onChange({
      item: updatedItem,
      isValid: validation.isValid
    });
  }, [onChange, validateForm]);
  const selectedOs = (0, _react.useMemo)(() => {
    var _currentItem$os_types;
    return (_currentItem$os_types = currentItem.os_types) !== null && _currentItem$os_types !== void 0 && _currentItem$os_types.length ? currentItem.os_types : [_securitysolutionUtils.OperatingSystem.WINDOWS, _securitysolutionUtils.OperatingSystem.MAC];
  }, [currentItem.os_types]);
  const currentEntry = (0, _react.useMemo)(() => {
    var _currentItem$entries3;
    const entry = (_currentItem$entries3 = currentItem.entries) === null || _currentItem$entries3 === void 0 ? void 0 : _currentItem$entries3[0];
    if (entry && 'value' in entry) {
      return entry;
    }
    return {
      field: _securitysolutionUtils.TrustedDeviceConditionEntryField.DEVICE_ID,
      operator: 'included',
      type: 'match',
      value: ''
    };
  }, [currentItem.entries]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "div",
    "data-test-subj": getTestId(''),
    error: submitError ? /*#__PURE__*/_react.default.createElement(_formatted_error.FormattedError, {
      error: submitError,
      "data-test-subj": getTestId('submitError'),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 615,
        columnNumber: 13
      }
    }) : undefined,
    isInvalid: !!submitError,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 610,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(DetailsSection, {
    mode: mode,
    getTestId: getTestId,
    item: currentItem,
    handleNameChange: handleNameChange,
    handleNameBlur: handleNameBlur,
    handleDescriptionChange: handleDescriptionChange,
    disabled: disabled,
    visitedFields: visitedFields,
    validationResult: validationResult,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 620,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 632,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(ConditionsSection, {
    getTestId: getTestId,
    selectedOs: selectedOs,
    handleOsChange: handleOsChange,
    currentEntry: currentEntry,
    handleFieldChange: handleFieldChange,
    handleOperatorChange: handleOperatorChange,
    handleValueChange: handleValueChange,
    handleValueBlur: handleValueBlur,
    disabled: disabled,
    visitedFields: visitedFields,
    validationResult: validationResult,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 634,
      columnNumber: 9
    }
  }), showAssignmentSection ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 650,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    "data-test-subj": getTestId('policySelection'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 652,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_effected_policy_select.EffectedPolicySelect, {
    item: currentItem,
    description: _translations2.POLICY_SELECT_DESCRIPTION,
    "data-test-subj": getTestId('effectedPolicies'),
    onChange: handlePolicyChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 653,
      columnNumber: 15
    }
  }))) : null);
});
TrustedDevicesForm.displayName = 'TrustedDevicesForm';