"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetTrustedDeviceSuggestions = void 0;
var _reactQuery = require("@kbn/react-query");
var _hooks = require("../../../../common/lib/kibana/hooks");
var _api_client = require("../service/api_client");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Hook to fetch autocomplete suggestions for trusted device fields
 * Uses React Query to handle race conditions when field changes rapidly
 */
const useGetTrustedDeviceSuggestions = ({
  field,
  query = '',
  enabled = true
}, options = {}) => {
  const http = (0, _hooks.useHttp)();
  return (0, _reactQuery.useQuery)({
    queryKey: ['trustedDevices', 'suggestions', field, query],
    ...options,
    queryFn: async () => {
      const apiClient = new _api_client.TrustedDevicesApiClient(http);
      return apiClient.getSuggestions({
        field,
        query
      });
    },
    enabled: !!field && enabled
  });
};
exports.useGetTrustedDeviceSuggestions = useGetTrustedDeviceSuggestions;