"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FleetIntegrationArtifactsCard = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _common = require("@kbn/fleet-plugin/common");
var _public = require("@kbn/fleet-plugin/public");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _kibana = require("../../../../../../../common/lib/kibana");
var _exception_items_summary = require("../../components/exception_items_summary");
var _link_with_icon = require("../../components/link_with_icon");
var _styled_components = require("../../endpoint_package_custom_extension/components/styled_components");
var _artifacts = require("../../../../../../hooks/artifacts");
var _use_test_id_generator = require("../../../../../../hooks/use_test_id_generator");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/pages/policy/view/ingest_manager_integration/endpoint_policy_edit_extension/components/fleet_integration_artifacts_card.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ARTIFACTS_LABELS = {
  artifactsSummaryApiError: error => _i18n.i18n.translate('xpack.securitySolution.endpoint.fleetIntegrationCard.artifactsSummary.error', {
    defaultMessage: 'There was an error trying to fetch artifacts stats: "{error}"',
    values: {
      error
    }
  }),
  cardTitle: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.fleetIntegrationCard.title",
    defaultMessage: "Artifacts",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 5
    }
  }),
  linkLabel: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.fleetIntegrationCard.artifactsManageLabel",
    defaultMessage: "Manage artifacts",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 5
    }
  })
};
const FleetIntegrationArtifactsCard = exports.FleetIntegrationArtifactsCard = /*#__PURE__*/(0, _react.memo)(({
  policyId,
  artifactApiClientInstance,
  getArtifactsPath,
  searchableFields,
  labels = ARTIFACTS_LABELS,
  privileges = true,
  'data-test-subj': dataTestSubj
}) => {
  const toasts = (0, _kibana.useToasts)();
  const {
    getAppUrl
  } = (0, _kibana.useAppUrl)();
  const policyArtifactsPath = getArtifactsPath(policyId);
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const {
    data
  } = (0, _artifacts.useSummaryArtifact)(artifactApiClientInstance, {
    policies: [policyId, 'all']
  }, searchableFields, {
    onError: error => {
      toasts.addDanger(labels.artifactsSummaryApiError(error.message));
    }
  });
  const policyArtifactsRouteState = (0, _react.useMemo)(() => {
    const fleetPackageIntegrationCustomUrlPath = `#${_public.pagePathGetters.integration_policy_edit({
      packagePolicyId: policyId
    })[1]}`;
    return {
      backLink: {
        label: _i18n.i18n.translate('xpack.securitySolution.endpoint.fleetIntegrationCard.artifacts.backButtonLabel', {
          defaultMessage: `Back to Fleet integration policy`
        }),
        navigateTo: [_common.INTEGRATIONS_PLUGIN_ID, {
          path: fleetPackageIntegrationCustomUrlPath
        }],
        href: getAppUrl({
          appId: _common.INTEGRATIONS_PLUGIN_ID,
          path: fleetPackageIntegrationCustomUrlPath
        })
      }
    };
  }, [getAppUrl, policyId]);
  const linkToArtifacts = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_link_with_icon.LinkWithIcon, {
    href: getAppUrl({
      path: policyArtifactsPath
    }),
    appPath: policyArtifactsPath,
    appState: policyArtifactsRouteState,
    "data-test-subj": getTestId('link-to-exceptions'),
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 9
    }
  }, labels.linkLabel), [getAppUrl, getTestId, labels.linkLabel, policyArtifactsPath, policyArtifactsRouteState]);

  // do not render if doesn't have privileges.
  // render if doesn't have privileges but has data to show
  if (data === undefined && !privileges || (data === null || data === void 0 ? void 0 : data.total) === 0 && !privileges) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    paddingSize: "l",
    hasBorder: true,
    "data-test-subj": getTestId('fleet-integration-card'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "baseline",
    justifyContent: "flexStart",
    gutterSize: "s",
    direction: "row",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 15
    }
  }, labels.cardTitle))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_exception_items_summary.ExceptionItemsSummary, {
    stats: data,
    isSmall: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_styled_components.StyledEuiFlexItem, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 11
    }
  }, linkToArtifacts)));
});
FleetIntegrationArtifactsCard.displayName = 'FleetIntegrationArtifactsCard';