"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.policyDetailsMiddlewareFactory = void 0;
var _policy_settings_middleware = require("./policy_settings_middleware");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const policyDetailsMiddlewareFactory = coreStart => {
  const middlewareContext = {
    coreStart
  };
  return store => next => async action => {
    next(action);
    (0, _policy_settings_middleware.policySettingsMiddlewareRunner)(middlewareContext, store, action);
  };
};
exports.policyDetailsMiddlewareFactory = policyDetailsMiddlewareFactory;