"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EndpointDetailsContent = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _workflow_insights = require("./components/insights/workflow_insights");
var _utils = require("../../utils");
var _agent_status = require("../../../../../common/components/endpoint/agents/agent_status");
var _hooks = require("../hooks");
var _selectors = require("../../store/selectors");
var _host_constants = require("../host_constants");
var _formatted_date = require("../../../../../common/components/formatted_date");
var _user_privileges = require("../../../../../common/components/user_privileges");
var _use_navigate_by_router_event_handler = require("../../../../../common/hooks/endpoint/use_navigate_by_router_event_handler");
var _routing = require("../../../../common/routing");
var _endpoint_policy_link = require("../../../../components/endpoint_policy_link");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/pages/endpoint_hosts/view/details/endpoint_details_content.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ColumnTitle = ({
  children
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 7
    }
  }, children));
};
const EndpointDetailsContent = exports.EndpointDetailsContent = /*#__PURE__*/(0, _react.memo)(({
  hostInfo,
  policyInfo
}) => {
  // Access control
  const {
    canReadWorkflowInsights
  } = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;
  const queryParams = (0, _hooks.useEndpointSelector)(_selectors.uiQueryParams);
  const policyStatus = (0, _react.useMemo)(() => hostInfo.metadata.Endpoint.policy.applied.status, [hostInfo]);
  const missingPolicies = (0, _hooks.useEndpointSelector)(_selectors.nonExistingPolicies);
  const policyResponseRoutePath = (0, _react.useMemo)(() => {
    const {
      selected_endpoint: selectedEndpoint,
      show,
      ...currentUrlParams
    } = queryParams;
    return (0, _routing.getEndpointDetailsPath)({
      name: 'endpointPolicyResponse',
      ...currentUrlParams,
      selected_endpoint: hostInfo.metadata.agent.id
    });
  }, [hostInfo.metadata.agent.id, queryParams]);
  const policyStatusClickHandler = (0, _use_navigate_by_router_event_handler.useNavigateByRouterEventHandler)(policyResponseRoutePath);
  const detailsResults = (0, _react.useMemo)(() => {
    return [{
      title: /*#__PURE__*/_react.default.createElement(ColumnTitle, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 71,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.endpoint.details.os",
        defaultMessage: "OS",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 72,
          columnNumber: 15
        }
      })),
      description: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 78,
          columnNumber: 24
        }
      }, hostInfo.metadata.host.os.full)
    }, {
      title: /*#__PURE__*/_react.default.createElement(ColumnTitle, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 82,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.endpoint.details.agentStatus",
        defaultMessage: "Agent Status",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 83,
          columnNumber: 15
        }
      })),
      description: /*#__PURE__*/_react.default.createElement(_agent_status.AgentStatus, {
        agentId: hostInfo.metadata.agent.id,
        agentType: "endpoint",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 89,
          columnNumber: 24
        }
      })
    }, {
      title: /*#__PURE__*/_react.default.createElement(ColumnTitle, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 93,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.endpoint.details.lastSeen",
        defaultMessage: "Last Seen",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 94,
          columnNumber: 15
        }
      })),
      description: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 101,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedDate, {
        value: hostInfo.last_checkin || hostInfo.metadata['@timestamp'],
        fieldName: "",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 102,
          columnNumber: 15
        }
      }))
    }, {
      title: /*#__PURE__*/_react.default.createElement(ColumnTitle, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 111,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.endpoint.details.policy",
        defaultMessage: "Policy",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 112,
          columnNumber: 15
        }
      })),
      description: /*#__PURE__*/_react.default.createElement(_endpoint_policy_link.EndpointPolicyLink, {
        policyId: hostInfo.metadata.Endpoint.policy.applied.id,
        revision: hostInfo.metadata.Endpoint.policy.applied.endpoint_policy_version,
        isOutdated: (0, _utils.isPolicyOutOfDate)(hostInfo.metadata.Endpoint.policy.applied, policyInfo),
        policyExists: !missingPolicies.has(hostInfo.metadata.Endpoint.policy.applied.id),
        "data-test-subj": "policyDetailsValue",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 119,
          columnNumber: 13
        }
      }, hostInfo.metadata.Endpoint.policy.applied.name)
    }, {
      title: /*#__PURE__*/_react.default.createElement(ColumnTitle, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 132,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.endpoint.details.policyStatus",
        defaultMessage: "Policy Status",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 133,
          columnNumber: 15
        }
      })),
      description: /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
        "data-test-subj": `policyStatusValue-${policyStatus}`,
        color: _host_constants.POLICY_STATUS_TO_BADGE_COLOR[policyStatus] || 'default',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 140,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        onClick: policyStatusClickHandler,
        "data-test-subj": "policyStatusValue",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 144,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 145,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.endpoint.details.policyStatusValue",
        defaultMessage: "{policyStatus, select, success {Success} warning {Warning} failure {Failed} other {Unknown}}",
        values: {
          policyStatus
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 146,
          columnNumber: 19
        }
      }))))
    }, {
      title: /*#__PURE__*/_react.default.createElement(ColumnTitle, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 158,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.endpoint.details.endpointVersion",
        defaultMessage: "Endpoint Version",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 159,
          columnNumber: 15
        }
      })),
      description: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 165,
          columnNumber: 24
        }
      }, hostInfo.metadata.agent.version)
    }, {
      title: /*#__PURE__*/_react.default.createElement(ColumnTitle, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 169,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.endpoint.details.ipAddress",
        defaultMessage: "IP Address",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 170,
          columnNumber: 15
        }
      })),
      description: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        direction: "column",
        gutterSize: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 177,
          columnNumber: 13
        }
      }, hostInfo.metadata.host.ip.map((ip, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        key: index,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 179,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 180,
          columnNumber: 19
        }
      }, ip))))
    }];
  }, [hostInfo, policyInfo, missingPolicies, policyStatus, policyStatusClickHandler]);
  return /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 7
    }
  }, canReadWorkflowInsights && /*#__PURE__*/_react.default.createElement(_workflow_insights.WorkflowInsights, {
    endpointId: hostInfo.metadata.agent.id,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 37
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    columnWidths: [1, 3],
    compressed: true,
    rowGutterSize: "m",
    type: "column",
    listItems: detailsResults,
    "data-test-subj": "endpointDetailsList",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 9
    }
  }));
});
EndpointDetailsContent.displayName = 'EndpointDetailsContent';