"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AdminSearchBar = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _rison = require("@kbn/rison");
var _public = require("@kbn/data-plugin/public");
var _public2 = require("@kbn/unified-search-plugin/public");
var _public3 = require("@kbn/kibana-utils-plugin/public");
var _url_from_query_params = require("../url_from_query_params");
var _hooks = require("../hooks");
var selectors = _interopRequireWildcard(require("../../store/selectors"));
var _index_pattern = require("../../models/index_pattern");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/pages/endpoint_hosts/view/components/search_bar.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AdminSearchBar = exports.AdminSearchBar = /*#__PURE__*/(0, _react.memo)(() => {
  const history = (0, _reactRouterDom.useHistory)();
  const {
    admin_query: _,
    ...queryParams
  } = (0, _hooks.useEndpointSelector)(selectors.uiQueryParams);
  const searchBarIndexPatterns = (0, _hooks.useEndpointSelector)(selectors.patterns);
  const searchBarQuery = (0, _hooks.useEndpointSelector)(selectors.searchBarQuery);
  const clonedIndexPatterns = (0, _react.useMemo)(() => searchBarIndexPatterns.map(pattern => (0, _index_pattern.clone)(pattern)), [searchBarIndexPatterns]);
  const onQuerySubmit = (0, _react.useCallback)(params => {
    var _params$query, _params$query2;
    history.push((0, _url_from_query_params.urlFromQueryParams)({
      ...queryParams,
      // if query is changed, reset back to first page
      // so that user is not (possibly) being left on an invalid page
      page_index: ((_params$query = params.query) === null || _params$query === void 0 ? void 0 : _params$query.query) === searchBarQuery.query ? queryParams.page_index : '0',
      ...((_params$query2 = params.query) !== null && _params$query2 !== void 0 && _params$query2.query.trim() ? {
        admin_query: (0, _rison.encode)(params.query)
      } : {})
    }));
  }, [history, queryParams, searchBarQuery.query]);
  const timeHistory = (0, _react.useMemo)(() => new _public.TimeHistory(new _public3.Storage(localStorage)), []);
  return /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 5
    }
  }, searchBarIndexPatterns && searchBarIndexPatterns.length > 0 && /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_public2.SearchBar, {
    dataTestSubj: "adminSearchBar",
    query: searchBarQuery,
    indexPatterns: clonedIndexPatterns,
    timeHistory: timeHistory,
    onQuerySubmit: onQuerySubmit,
    fillSubmitButton: true,
    isLoading: false,
    iconType: "search",
    showFilterBar: false,
    showDatePicker: false,
    showQueryInput: true,
    suggestionsAbstraction: {
      type: 'endpoints',
      fields: {}
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 11
    }
  })));
});
AdminSearchBar.displayName = 'AdminSearchBar';