"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResponseActionFileDownloadLink = exports.FILE_TRUNCATED_MESSAGE = exports.FILE_PASSCODE_INFO_MESSAGE = exports.FILE_NO_LONGER_AVAILABLE_MESSAGE = exports.FILE_DELETED_MESSAGE = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _kibana = require("../../../common/lib/kibana");
var _constants = require("../../../../common/endpoint/service/response_actions/constants");
var _get_file_download_id = require("../../../../common/endpoint/service/response_actions/get_file_download_id");
var _resolve_path_variables = require("../../../common/utils/resolve_path_variables");
var _formatted_error = require("../formatted_error");
var _use_get_file_info = require("../../hooks/response_actions/use_get_file_info");
var _use_test_id_generator = require("../../hooks/use_test_id_generator");
var _constants2 = require("../../../../common/endpoint/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/response_action_file_download_link/response_action_file_download_link.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const STYLE_INHERIT_FONT_FAMILY = {
  fontFamily: 'inherit'
};
const DEFAULT_BUTTON_TITLE = _i18n.i18n.translate('xpack.securitySolution.responseActionFileDownloadLink.downloadButtonLabel', {
  defaultMessage: 'Click here to download'
});
const FILE_NO_LONGER_AVAILABLE_MESSAGE = exports.FILE_NO_LONGER_AVAILABLE_MESSAGE = _i18n.i18n.translate('xpack.securitySolution.responseActionFileDownloadLink.fileNoLongerAvailable', {
  defaultMessage: 'File has expired and is no longer available for download.'
});
const FILE_DELETED_MESSAGE = exports.FILE_DELETED_MESSAGE = _i18n.i18n.translate('xpack.securitySolution.responseActionFileDownloadLink.deleteNotice', {
  defaultMessage: 'Files are periodically deleted to clear storage space. Download and save file locally if needed.'
});
const FILE_PASSCODE_INFO_MESSAGE = passcode => _i18n.i18n.translate('xpack.securitySolution.responseActionFileDownloadLink.passcodeInfo', {
  defaultMessage: '(ZIP file passcode: {passcode}).',
  values: {
    passcode
  }
});
exports.FILE_PASSCODE_INFO_MESSAGE = FILE_PASSCODE_INFO_MESSAGE;
const FILE_TRUNCATED_MESSAGE = exports.FILE_TRUNCATED_MESSAGE = _i18n.i18n.translate('xpack.securitySolution.responseActionFileDownloadLink.fileTruncated', {
  defaultMessage: 'Output data in the provided zip file is truncated due to file size limitations.'
});
const FileDownloadLinkContainer = _styledComponents.default.div`
  & > * {
    vertical-align: middle;
  }
`;
const TruncatedTextInfo = /*#__PURE__*/(0, _react.memo)(({
  textSize,
  'data-test-subj': dataTestSubj
}) => {
  const alertIconSize = (0, _react.useMemo)(() => textSize === 'xs' ? 's' : 'm', [textSize]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    justifyContent: "flexStart",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: alertIconSize,
    type: "warning",
    color: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: textSize,
    color: "warning",
    "data-test-subj": dataTestSubj,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 13
    }
  }, FILE_TRUNCATED_MESSAGE))));
});
TruncatedTextInfo.displayName = 'TruncatedTextInfo';
/**
 * Displays the download link for a file retrieved via a Response Action. The download link
 * button will only be displayed if the user has authorization to use file operations.
 *
 * NOTE: Currently displays only the link for the first host in the Action
 */
const ResponseActionFileDownloadLink = exports.ResponseActionFileDownloadLink = /*#__PURE__*/(0, _react.memo)(({
  action: _action,
  agentId,
  buttonTitle = DEFAULT_BUTTON_TITLE,
  canAccessFileDownloadLink,
  isTruncatedFile = false,
  showPasscode = true,
  textSize = 's',
  'data-test-subj': dataTestSubj
}) => {
  var _error$response;
  const action = _action; // cast to remove `Immutable`
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const http = (0, _kibana.useHttp)();
  const shouldFetchFileInfo = (0, _react.useMemo)(() => {
    return action.isCompleted && action.wasSuccessful;
  }, [action.isCompleted, action.wasSuccessful]);
  const downloadUrl = (0, _react.useMemo)(() => {
    return `${http.basePath.get()}${(0, _resolve_path_variables.resolvePathVariables)(_constants2.ACTION_AGENT_FILE_DOWNLOAD_ROUTE, {
      action_id: action.id,
      file_id: (0, _get_file_download_id.getFileDownloadId)(action, agentId)
    })}?apiVersion=2023-10-31`;
  }, [action, agentId, http.basePath]);
  const {
    isLoading,
    data: fileInfo,
    error
  } = (0, _use_get_file_info.useGetFileInfo)(action, undefined, {
    enabled: canAccessFileDownloadLink && shouldFetchFileInfo
  });
  if (!canAccessFileDownloadLink || !action.isCompleted || !action.wasSuccessful) {
    return null;
  }
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
      lines: 1,
      "data-test-subj": getTestId('loading'),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 162,
        columnNumber: 14
      }
    });
  }

  // Check if file is no longer available
  if (error && (error === null || error === void 0 ? void 0 : (_error$response = error.response) === null || _error$response === void 0 ? void 0 : _error$response.status) === 404 || (fileInfo === null || fileInfo === void 0 ? void 0 : fileInfo.data.status) === 'DELETED') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: textSize,
      color: "warning",
      "data-test-subj": getTestId('fileNoLongerAvailable'),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 168,
        columnNumber: 9
      }
    }, FILE_NO_LONGER_AVAILABLE_MESSAGE);
  } else if (error) {
    return /*#__PURE__*/_react.default.createElement(_formatted_error.FormattedError, {
      error: error,
      "data-test-subj": getTestId('apiError'),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 177,
        columnNumber: 14
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(FileDownloadLinkContainer, {
    "data-test-subj": dataTestSubj,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    href: downloadUrl,
    iconType: "download",
    "data-test-subj": getTestId('downloadButton'),
    flush: "left",
    css: STYLE_INHERIT_FONT_FAMILY,
    iconSize: "s",
    download: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: textSize,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 11
    }
  }, buttonTitle)), showPasscode && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: textSize,
    "data-test-subj": getTestId('passcodeMessage'),
    className: "eui-displayInline",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 11
    }
  }, FILE_PASSCODE_INFO_MESSAGE(_constants.RESPONSE_ACTIONS_ZIP_PASSCODE[action.agentType])), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: textSize,
    color: "warning",
    "data-test-subj": getTestId('fileDeleteMessage'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 9
    }
  }, FILE_DELETED_MESSAGE), isTruncatedFile && /*#__PURE__*/_react.default.createElement(TruncatedTextInfo, {
    textSize: textSize,
    "data-test-subj": getTestId('fileTruncatedMessage'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 11
    }
  }));
});
ResponseActionFileDownloadLink.displayName = 'ResponseActionFileDownloadLink';