"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CommandUsage = exports.CommandInputUsage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _use_input_command = require("../hooks/state_selectors/use_input_command");
var _console_code_block = require("./console_code_block");
var _parsed_command_input = require("../service/parsed_command_input");
var _use_test_id_generator = require("../../../hooks/use_test_id_generator");
var _use_data_test_subj = require("../hooks/state_selectors/use_data_test_subj");
var _unsupported_message_callout = require("./unsupported_message_callout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/console/components/command_usage.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const additionalProps = {
  className: 'euiTruncateText'
};
const CommandInputUsage = exports.CommandInputUsage = /*#__PURE__*/(0, _react.memo)(({
  commandDef
}) => {
  const inputCommand = (0, _use_input_command.useInputCommand)();
  const usageHelp = (0, _react.useMemo)(() => {
    return (0, _parsed_command_input.getArgumentsForCommand)(commandDef).map((usage, index) => {
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
        key: `helpUsage-${index}`,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 30,
          columnNumber: 9
        }
      }, index > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "xs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 31,
          columnNumber: 25
        }
      }), /*#__PURE__*/_react.default.createElement(_console_code_block.ConsoleCodeBlock, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 32,
          columnNumber: 11
        }
      }, `${commandDef.name} ${usage}`));
    });
  }, [commandDef]);
  const helpExample = (0, _react.useMemo)(() => {
    if (commandDef.helpUsage) {
      return commandDef.helpUsage;
    }
    return typeof commandDef.exampleUsage === 'function' ? commandDef.exampleUsage(inputCommand) : commandDef.exampleUsage;
  }, [commandDef, inputCommand]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    compressed: true,
    type: "column",
    columnWidths: [1, 4],
    listItems: [{
      title: /*#__PURE__*/_react.default.createElement(_console_code_block.ConsoleCodeBlock, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 57,
          columnNumber: 15
        }
      }, _i18n.i18n.translate('xpack.securitySolution.console.commandUsage.inputUsage', {
        defaultMessage: 'Usage'
      })),
      description: usageHelp && usageHelp.length > 0 ? usageHelp : commandDef.name
    }],
    descriptionProps: additionalProps,
    titleProps: additionalProps,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 7
    }
  }), helpExample && /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    compressed: true,
    type: "column",
    columnWidths: [1, 4],
    listItems: [{
      title: /*#__PURE__*/_react.default.createElement(_console_code_block.ConsoleCodeBlock, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 78,
          columnNumber: 17
        }
      }, _i18n.i18n.translate('xpack.securitySolution.console.commandUsage.exampleUsage', {
        defaultMessage: 'Example'
      })),
      description: /*#__PURE__*/_react.default.createElement(_console_code_block.ConsoleCodeBlock, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 84,
          columnNumber: 28
        }
      }, helpExample)
    }],
    descriptionProps: additionalProps,
    titleProps: additionalProps,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 9
    }
  }));
});
CommandInputUsage.displayName = 'CommandInputUsage';
const CommandUsage = exports.CommandUsage = /*#__PURE__*/(0, _react.memo)(({
  commandDef,
  errorMessage
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)((0, _use_data_test_subj.useDataTestSubj)());
  const hasArgs = (0, _react.useMemo)(() => {
    var _commandDef$args;
    return Object.keys((_commandDef$args = commandDef.args) !== null && _commandDef$args !== void 0 ? _commandDef$args : []).length > 0;
  }, [commandDef.args]);
  const commandOptions = (0, _react.useMemo)(() => {
    if (!hasArgs || !commandDef.args) {
      return {
        required: [],
        exclusiveOr: [],
        optional: []
      };
    }
    const enteredCommands = Object.entries(commandDef.args).reduce((acc, curr) => {
      const item = {
        title: `--${curr[0]}`,
        description: curr[1].about
      };
      if (curr[1].required) {
        acc.required.push(item);
      } else if (curr[1].exclusiveOr) {
        acc.exclusiveOr.push(item);
      } else {
        acc.optional.push(item);
      }
      return acc;
    }, {
      required: [],
      exclusiveOr: [],
      optional: []
    });
    return enteredCommands;
  }, [commandDef.args, hasArgs]);
  const parametersDescriptionList = (title, parameters) => {
    const description = parameters.map(item => /*#__PURE__*/_react.default.createElement("div", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 150,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_console_code_block.ConsoleCodeBlock, {
      bold: true,
      inline: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 151,
        columnNumber: 9
      }
    }, item.title), /*#__PURE__*/_react.default.createElement(_console_code_block.ConsoleCodeBlock, {
      inline: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 154,
        columnNumber: 9
      }
    }, ' - ', item.description)));
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 162,
        columnNumber: 9
      }
    }), commandDef.args && /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
      compressed: true,
      type: "column",
      columnWidths: [1, 4],
      listItems: [{
        title: /*#__PURE__*/_react.default.createElement(_console_code_block.ConsoleCodeBlock, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 168,
            columnNumber: 34
          }
        }, title),
        description
      }],
      descriptionProps: additionalProps,
      titleProps: additionalProps,
      "data-test-subj": getTestId('commandUsage-options'),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 164,
        columnNumber: 11
      }
    }));
  };
  const renderErrorMessage = (0, _react.useCallback)(() => {
    if (!errorMessage) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_unsupported_message_callout.UnsupportedMessageCallout, {
      header: /*#__PURE__*/_react.default.createElement(_console_code_block.ConsoleCodeBlock, {
        textColor: "danger",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 185,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.console.validationError.title",
        defaultMessage: "Unsupported action",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 186,
          columnNumber: 13
        }
      })),
      "data-test-subj": getTestId('validationError'),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 183,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": getTestId('badArgument-message'),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 194,
        columnNumber: 9
      }
    }, errorMessage), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 195,
        columnNumber: 9
      }
    }));
  }, [errorMessage, getTestId]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "none",
    color: "transparent",
    "data-test-subj": getTestId('commandUsage'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 5
    }
  }, renderErrorMessage(), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    compressed: true,
    type: "column",
    columnWidths: [1, 4],
    listItems: [{
      title: /*#__PURE__*/_react.default.createElement(_console_code_block.ConsoleCodeBlock, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 210,
          columnNumber: 15
        }
      }, _i18n.i18n.translate('xpack.securitySolution.console.commandUsage.about', {
        defaultMessage: 'About'
      })),
      description: /*#__PURE__*/_react.default.createElement(_console_code_block.ConsoleCodeBlock, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 216,
          columnNumber: 26
        }
      }, commandDef.about)
    }],
    descriptionProps: additionalProps,
    titleProps: additionalProps,
    "data-test-subj": getTestId('commandUsage-options'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 223,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(CommandInputUsage, {
    commandDef: commandDef,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 224,
      columnNumber: 7
    }
  }), commandOptions.required && commandOptions.required.length > 0 && parametersDescriptionList(_i18n.i18n.translate('xpack.securitySolution.console.commandUsage.requiredLabel', {
    defaultMessage: 'Required parameters'
  }), commandOptions.required), commandOptions.exclusiveOr && commandOptions.exclusiveOr.length > 0 && parametersDescriptionList(_i18n.i18n.translate('xpack.securitySolution.console.commandUsage.exclusiveOr', {
    defaultMessage: 'Include only one parameter'
  }), commandOptions.exclusiveOr), commandOptions.optional && commandOptions.optional.length > 0 && parametersDescriptionList(_i18n.i18n.translate('xpack.securitySolution.console.commandUsage.optional', {
    defaultMessage: 'Optional parameters'
  }), commandOptions.optional));
});
CommandUsage.displayName = 'CommandUsage';