"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CommandExecutionOutput = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _moment = _interopRequireDefault(require("moment"));
var _long_running_command_hint = require("./long_running_command_hint");
var _command_execution_result = require("./command_execution_result");
var _user_command_input = require("./user_command_input");
var _use_console_state_dispatch = require("../hooks/state_selectors/use_console_state_dispatch");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/console/components/command_execution_output.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CommandOutputContainer = _styledComponents.default.div`
  position: relative;

  .busy-indicator {
    margin-left: 0.5em;
  }
`;
const CommandExecutionOutput = exports.CommandExecutionOutput = /*#__PURE__*/(0, _react.memo)(({
  item: {
    command,
    state,
    id,
    enteredAt,
    isValid
  }
}) => {
  const dispatch = (0, _use_console_state_dispatch.useConsoleStateDispatch)();
  const RenderComponent = command.commandDefinition.RenderComponent;
  const [isLongRunningCommand, setIsLongRunningCommand] = (0, _react.useState)(false);
  const isRunning = (0, _react.useMemo)(() => {
    return state.status === 'pending';
  }, [state.status]);

  /** Updates the Command's status */
  const setCommandStatus = (0, _react.useCallback)(status => {
    dispatch({
      type: 'updateCommandStatusState',
      payload: {
        id,
        value: status
      }
    });
  }, [dispatch, id]);

  /** Updates the Command's execution store */
  const setCommandStore = (0, _react.useCallback)(updateStoreFn => {
    dispatch({
      type: 'updateCommandStoreState',
      payload: {
        id,
        value: updateStoreFn
      }
    });
  }, [dispatch, id]);

  // keep track if this becomes a long running command
  (0, _react.useEffect)(() => {
    let timeoutId;
    if (isRunning && !isLongRunningCommand) {
      const elapsedSeconds = (0, _moment.default)().diff((0, _moment.default)(enteredAt), 'seconds');
      if (elapsedSeconds >= 15) {
        setIsLongRunningCommand(true);
        return;
      }
      timeoutId = setTimeout(() => {
        setIsLongRunningCommand(true);
      }, (15 - elapsedSeconds) * 1000);
    }
    return () => {
      if (timeoutId) {
        clearTimeout(timeoutId);
      }
    };
  }, [enteredAt, isLongRunningCommand, isRunning]);
  return /*#__PURE__*/_react.default.createElement(CommandOutputContainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_user_command_input.UserCommandInput, {
    input: command.inputDisplay,
    isValid: isValid,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement("div", {
    className: "noThemeOverrides",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(RenderComponent, {
    command: command,
    store: state.store,
    status: state.status,
    setStore: setCommandStore,
    setStatus: setCommandStatus,
    ResultComponent: _command_execution_result.CommandExecutionResult,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 11
    }
  }), isRunning && /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, {
    className: "busy-indicator",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 25
    }
  }), isRunning && isLongRunningCommand && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_long_running_command_hint.LongRunningCommandHint, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 15
    }
  }))));
});
CommandExecutionOutput.displayName = 'CommandExecutionOutput';