"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useNormalizedArtifact = void 0;
var _react = require("react");
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Takes in any artifact and return back a new data structure used internally with by the card's components
 *
 * @param item
 */
const useNormalizedArtifact = item => {
  return (0, _react.useMemo)(() => {
    return (0, _utils.mapToArtifactInfo)(item);
  }, [item]);
};
exports.useNormalizedArtifact = useNormalizedArtifact;