"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CriteriaConditions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _securitysolutionIoTsListTypes = require("@kbn/securitysolution-io-ts-list-types");
var _translations = require("./translations");
var _use_test_id_generator = require("../../../hooks/use_test_id_generator");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/artifact_entry_card/components/criteria_conditions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const OS_LABELS = Object.freeze({
  linux: _translations.OS_LINUX,
  mac: _translations.OS_MAC,
  macos: _translations.OS_MAC,
  windows: _translations.OS_WINDOWS
});
const OPERATOR_TYPE_LABELS_INCLUDED = Object.freeze({
  [_securitysolutionIoTsListTypes.ListOperatorTypeEnum.NESTED]: _translations.CONDITION_OPERATOR_TYPE_NESTED,
  [_securitysolutionIoTsListTypes.ListOperatorTypeEnum.MATCH_ANY]: _translations.CONDITION_OPERATOR_TYPE_MATCH_ANY,
  [_securitysolutionIoTsListTypes.ListOperatorTypeEnum.MATCH]: _translations.CONDITION_OPERATOR_TYPE_MATCH,
  [_securitysolutionIoTsListTypes.ListOperatorTypeEnum.WILDCARD]: _translations.CONDITION_OPERATOR_TYPE_WILDCARD_MATCHES,
  [_securitysolutionIoTsListTypes.ListOperatorTypeEnum.EXISTS]: _translations.CONDITION_OPERATOR_TYPE_EXISTS,
  [_securitysolutionIoTsListTypes.ListOperatorTypeEnum.LIST]: _translations.CONDITION_OPERATOR_TYPE_LIST
});
const OPERATOR_TYPE_LABELS_EXCLUDED = Object.freeze({
  [_securitysolutionIoTsListTypes.ListOperatorTypeEnum.MATCH_ANY]: _translations.CONDITION_OPERATOR_TYPE_NOT_MATCH_ANY,
  [_securitysolutionIoTsListTypes.ListOperatorTypeEnum.MATCH]: _translations.CONDITION_OPERATOR_TYPE_NOT_MATCH,
  [_securitysolutionIoTsListTypes.ListOperatorTypeEnum.WILDCARD]: _translations.CONDITION_OPERATOR_TYPE_DOES_NOT_MATCH
});
const EuiFlexGroupNested = (0, _styled.default)(_eui.EuiFlexGroup)`
  margin-left: ${({
  theme
}) => theme.euiTheme.size.xl};
`;
const EuiFlexItemNested = (0, _styled.default)(_eui.EuiFlexItem)`
  margin-bottom: ${({
  theme
}) => theme.euiTheme.size.s} !important;
  margin-top: ${({
  theme
}) => theme.euiTheme.size.s} !important;
`;
const StyledCondition = (0, _styled.default)('span')`
  margin-right: ${({
  theme
}) => theme.euiTheme.size.s};
`;
const CriteriaConditions = exports.CriteriaConditions = /*#__PURE__*/(0, _react.memo)(({
  os,
  entries,
  'data-test-subj': dataTestSubj
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const osLabel = (0, _react.useMemo)(() => {
    return os.map(osValue => {
      var _OS_LABELS;
      return (_OS_LABELS = OS_LABELS[osValue]) !== null && _OS_LABELS !== void 0 ? _OS_LABELS : osValue;
    }).join(', ');
  }, [os]);
  const getEntryValue = (type, value) => {
    if (type === 'match_any' && Array.isArray(value)) {
      return value.map(currentValue => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "hollow",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 82,
          columnNumber: 44
        }
      }, currentValue));
    }
    return value;
  };
  const getEntryOperator = (type, operator) => {
    var _OPERATOR_TYPE_LABELS, _OPERATOR_TYPE_LABELS2;
    if (type === 'nested') return '';
    return operator === 'included' ? (_OPERATOR_TYPE_LABELS = OPERATOR_TYPE_LABELS_INCLUDED[type]) !== null && _OPERATOR_TYPE_LABELS !== void 0 ? _OPERATOR_TYPE_LABELS : type : (_OPERATOR_TYPE_LABELS2 = OPERATOR_TYPE_LABELS_EXCLUDED[type]) !== null && _OPERATOR_TYPE_LABELS2 !== void 0 ? _OPERATOR_TYPE_LABELS2 : type;
  };
  const getNestedEntriesContent = (0, _react.useCallback)((type, nestedEntries) => {
    if (type === 'nested' && nestedEntries.length) {
      return nestedEntries.map(({
        field: nestedField,
        type: nestedType,
        value: nestedValue,
        operator: nestedOperator
      }) => {
        return /*#__PURE__*/_react.default.createElement(EuiFlexGroupNested, {
          "data-test-subj": getTestId('nestedCondition'),
          key: nestedField + nestedType + nestedValue,
          direction: "row",
          alignItems: "center",
          gutterSize: "m",
          responsive: false,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 105,
            columnNumber: 17
          }
        }, /*#__PURE__*/_react.default.createElement(EuiFlexItemNested, {
          grow: false,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 113,
            columnNumber: 19
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiToken, {
          iconType: "tokenNested",
          size: "s",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 114,
            columnNumber: 21
          }
        })), /*#__PURE__*/_react.default.createElement(EuiFlexItemNested, {
          grow: false,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 116,
            columnNumber: 19
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
          description: '',
          value: nestedField,
          color: "subdued",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 117,
            columnNumber: 21
          }
        })), /*#__PURE__*/_react.default.createElement(EuiFlexItemNested, {
          grow: false,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 119,
            columnNumber: 19
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
          description: getEntryOperator(nestedType, nestedOperator),
          value: getEntryValue(nestedType, nestedValue),
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 120,
            columnNumber: 21
          }
        })));
      });
    }
  }, [getTestId]);
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": dataTestSubj,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": getTestId('os'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("strong", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
    description: '',
    value: _translations.CONDITION_OS,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
    description: _translations.CONDITION_OPERATOR_TYPE_MATCH,
    value: osLabel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 13
    }
  }))), entries.map(({
    field,
    type,
    value,
    operator,
    entries: nestedEntries = []
  }) => {
    return /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": getTestId('condition'),
      key: field + type + value,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 144,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "eui-xScroll",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 145,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
      description: /*#__PURE__*/_react.default.createElement(StyledCondition, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 147,
          columnNumber: 32
        }
      }, _translations.CONDITION_AND),
      value: field,
      color: "subdued",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 146,
        columnNumber: 17
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
      description: getEntryOperator(type, operator),
      value: getEntryValue(type, value),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 151,
        columnNumber: 17
      }
    })), getNestedEntriesContent(type, nestedEntries));
  }));
});
CriteriaConditions.displayName = 'CriteriaConditions';