"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getOktaUserIndex = exports.getEntraUserIndex = exports.UserPanelKey = exports.ServicePanelKey = exports.ONE_WEEK_IN_HOURS = exports.OKTA_PACKAGE_NAME = exports.MANAGED_USER_QUERY_ID = exports.HostPanelKey = exports.GenericEntityPanelKey = exports.EntityPanelParamByType = exports.EntityPanelKeyByType = exports.ENTRA_ID_PACKAGE_NAME = void 0;
var _types = require("../../../../common/entity_analytics/types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ONE_WEEK_IN_HOURS = exports.ONE_WEEK_IN_HOURS = 24 * 7;
const getEntraUserIndex = (spaceId = 'default') => `logs-entityanalytics_entra_id.user-${spaceId}`;
exports.getEntraUserIndex = getEntraUserIndex;
const ENTRA_ID_PACKAGE_NAME = exports.ENTRA_ID_PACKAGE_NAME = 'entityanalytics_entra_id';
const getOktaUserIndex = (spaceId = 'default') => `logs-entityanalytics_okta.user-${spaceId}`;
exports.getOktaUserIndex = getOktaUserIndex;
const OKTA_PACKAGE_NAME = exports.OKTA_PACKAGE_NAME = 'entityanalytics_okta';
const MANAGED_USER_QUERY_ID = exports.MANAGED_USER_QUERY_ID = 'managedUserDetailsQuery';
const HostPanelKey = exports.HostPanelKey = 'host-panel';
const UserPanelKey = exports.UserPanelKey = 'user-panel';
const ServicePanelKey = exports.ServicePanelKey = 'service-panel';
const GenericEntityPanelKey = exports.GenericEntityPanelKey = 'generic-entity-panel';
const EntityPanelKeyByType = exports.EntityPanelKeyByType = {
  [_types.EntityType.host]: HostPanelKey,
  [_types.EntityType.user]: UserPanelKey,
  [_types.EntityType.service]: ServicePanelKey,
  [_types.EntityType.generic]: undefined // TODO create generic flyout?
};

// TODO rename all params and merged them as 'entityName'
const EntityPanelParamByType = exports.EntityPanelParamByType = {
  [_types.EntityType.host]: 'hostName',
  [_types.EntityType.user]: 'userName',
  [_types.EntityType.service]: 'serviceName',
  [_types.EntityType.generic]: undefined // TODO create generic flyout?
};