"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TakeActionDropdown = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _fp = require("lodash/fp");
var _test_ids = require("./test_ids");
var _get_event_details_field_values = require("../../../../common/lib/endpoint/utils/get_event_details_field_values");
var _use_add_exception_actions = require("../../../../detections/components/alerts_table/timeline_actions/use_add_exception_actions");
var _use_alerts_actions = require("../../../../detections/components/alerts_table/timeline_actions/use_alerts_actions");
var _use_investigate_in_timeline = require("../../../../detections/components/alerts_table/timeline_actions/use_investigate_in_timeline");
var _use_event_filter_action = require("../../../../detections/components/alerts_table/timeline_actions/use_event_filter_action");
var _responder = require("../../../../common/components/endpoint/responder");
var _host_isolation = require("../../../../common/components/endpoint/host_isolation");
var _user_privileges = require("../../../../common/components/user_privileges");
var _use_add_to_case_actions = require("../../../../detections/components/alerts_table/timeline_actions/use_add_to_case_actions");
var _kibana = require("../../../../common/lib/kibana");
var _osquery_action_item = require("../../../../detections/components/osquery/osquery_action_item");
var _use_alert_tags_actions = require("../../../../detections/components/alerts_table/timeline_actions/use_alert_tags_actions");
var _use_alert_assignees_actions = require("../../../../detections/components/alerts_table/timeline_actions/use_alert_assignees_actions");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/document_details/shared/components/take_action_dropdown.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TAKE_ACTION = _i18n.i18n.translate('xpack.securitySolution.flyout.footer.takeActionButtonLabel', {
  defaultMessage: 'Take action'
});
/**
 * Take action button with dropdown used to show all the options available to the user on a document rendered in the expandable flyout
 */
const TakeActionDropdown = exports.TakeActionDropdown = /*#__PURE__*/(0, _react.memo)(({
  dataFormattedForFieldBrowser,
  dataAsNestedObject,
  handleOnEventClosed,
  isHostIsolationPanelOpen,
  onAddEventFilterClick,
  onAddExceptionTypeClick,
  onAddIsolationStatusClick,
  refetch,
  refetchFlyoutData,
  onOsqueryClick,
  scopeId
}) => {
  var _dataFormattedForFiel;
  // popover interaction
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const togglePopoverHandler = (0, _react.useCallback)(() => {
    setIsPopoverOpen(!isPopoverOpen);
  }, [isPopoverOpen]);
  const closePopoverHandler = (0, _react.useCallback)(() => {
    setIsPopoverOpen(false);
  }, []);
  const onMenuItemClick = (0, _react.useCallback)(() => {
    closePopoverHandler();
  }, [closePopoverHandler]);
  const closePopoverAndFlyout = (0, _react.useCallback)(() => {
    handleOnEventClosed();
    setIsPopoverOpen(false);
  }, [handleOnEventClosed]);
  const alertSummaryData = (0, _react.useMemo)(() => [{
    category: 'kibana',
    field: 'kibana.alert.rule.uuid',
    name: 'ruleId'
  }, {
    category: 'kibana',
    field: 'kibana.alert.rule.name',
    name: 'ruleName'
  }, {
    category: 'kibana',
    field: 'kibana.alert.workflow_status',
    name: 'alertStatus'
  }, {
    category: 'event',
    field: 'event.kind',
    name: 'eventKind'
  }, {
    category: '_id',
    field: '_id',
    name: 'eventId'
  }].reduce((acc, curr) => ({
    ...acc,
    [curr.name]: (0, _get_event_details_field_values.getAlertDetailsFieldValue)({
      category: curr.category,
      field: curr.field
    }, dataFormattedForFieldBrowser)
  }), {}), [dataFormattedForFieldBrowser]);
  const isEvent = alertSummaryData.eventKind === 'event';
  const isAgentEndpoint = (0, _react.useMemo)(() => {
    var _dataAsNestedObject$a, _dataAsNestedObject$a2;
    return dataAsNestedObject === null || dataAsNestedObject === void 0 ? void 0 : (_dataAsNestedObject$a = dataAsNestedObject.agent) === null || _dataAsNestedObject$a === void 0 ? void 0 : (_dataAsNestedObject$a2 = _dataAsNestedObject$a.type) === null || _dataAsNestedObject$a2 === void 0 ? void 0 : _dataAsNestedObject$a2.includes('endpoint');
  }, [dataAsNestedObject]);
  const isAlertSourceEndpoint = (0, _react.useMemo)(() => {
    const eventModules = (0, _fp.getOr)([], 'kibana.alert.original_event.module', dataAsNestedObject);
    const kinds = (0, _fp.getOr)([], 'kibana.alert.original_event.kind', dataAsNestedObject);
    return eventModules.includes('endpoint') && kinds.includes('alert');
  }, [dataAsNestedObject]);

  // host isolation interaction
  const handleOnAddIsolationStatusClick = (0, _react.useCallback)(action => {
    onAddIsolationStatusClick(action);
    setIsPopoverOpen(false);
  }, [onAddIsolationStatusClick]);
  const hostIsolationActionItems = (0, _host_isolation.useHostIsolationAction)({
    closePopover: closePopoverHandler,
    detailsData: dataFormattedForFieldBrowser,
    onAddIsolationStatusClick: handleOnAddIsolationStatusClick,
    isHostIsolationPanelOpen
  });

  // exception interaction
  const handleOnAddExceptionTypeClick = (0, _react.useCallback)(type => {
    onAddExceptionTypeClick(type);
    setIsPopoverOpen(false);
  }, [onAddExceptionTypeClick]);
  const {
    exceptionActionItems
  } = (0, _use_add_exception_actions.useAlertExceptionActions)({
    isEndpointAlert: isAlertSourceEndpoint,
    onAddExceptionTypeClick: handleOnAddExceptionTypeClick
  });

  // event filter interaction
  const handleOnAddEventFilterClick = (0, _react.useCallback)(() => {
    onAddEventFilterClick();
    setIsPopoverOpen(false);
  }, [onAddEventFilterClick]);
  const {
    eventFilterActionItems
  } = (0, _use_event_filter_action.useEventFilterAction)({
    onAddEventFilterClick: handleOnAddEventFilterClick
  });
  const {
    loading: endpointPrivilegesLoading,
    canWriteEventFilters
  } = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;
  const isEndpointEvent = (0, _react.useMemo)(() => isEvent && isAgentEndpoint, [isEvent, isAgentEndpoint]);
  const canCreateEndpointEventFilters = (0, _react.useMemo)(() => !endpointPrivilegesLoading && canWriteEventFilters, [canWriteEventFilters, endpointPrivilegesLoading]);

  // alert status interaction
  const {
    actionItems: statusActionItems,
    panels: statusActionPanels
  } = (0, _use_alerts_actions.useAlertsActions)({
    alertStatus: alertSummaryData.alertStatus,
    closePopover: closePopoverAndFlyout,
    eventId: alertSummaryData.eventId,
    refetch,
    scopeId
  });

  // alert tagging interation
  const {
    alertTagsItems,
    alertTagsPanels
  } = (0, _use_alert_tags_actions.useAlertTagsActions)({
    closePopover: closePopoverHandler,
    ecsRowData: dataAsNestedObject !== null && dataAsNestedObject !== void 0 ? dataAsNestedObject : {
      _id: alertSummaryData.eventId
    },
    refetch
  });

  // assignee interaction
  const onAssigneesUpdate = (0, _react.useCallback)(() => {
    if (refetch) {
      refetch();
    }
    if (refetchFlyoutData) {
      refetchFlyoutData();
    }
  }, [refetch, refetchFlyoutData]);
  const {
    alertAssigneesItems,
    alertAssigneesPanels
  } = (0, _use_alert_assignees_actions.useAlertAssigneesActions)({
    closePopover: closePopoverHandler,
    ecsRowData: dataAsNestedObject !== null && dataAsNestedObject !== void 0 ? dataAsNestedObject : {
      _id: alertSummaryData.eventId
    },
    refetch: onAssigneesUpdate
  });

  // timeline interaction
  const {
    investigateInTimelineActionItems
  } = (0, _use_investigate_in_timeline.useInvestigateInTimeline)({
    ecsRowData: dataAsNestedObject,
    onInvestigateInTimelineAlertClick: closePopoverHandler
  });

  // osquery interaction
  const osqueryAgentId = (0, _react.useMemo)(() => (0, _get_event_details_field_values.getAlertDetailsFieldValue)({
    category: 'agent',
    field: 'agent.id'
  }, dataFormattedForFieldBrowser), [dataFormattedForFieldBrowser]);
  const handleOnOsqueryClick = (0, _react.useCallback)(() => {
    onOsqueryClick(osqueryAgentId);
    setIsPopoverOpen(false);
  }, [onOsqueryClick, setIsPopoverOpen, osqueryAgentId]);
  const osqueryActionItem = (0, _react.useMemo)(() => (0, _osquery_action_item.getOsqueryActionItem)({
    handleClick: handleOnOsqueryClick
  }), [handleOnOsqueryClick]);
  const {
    osquery
  } = (0, _kibana.useKibana)().services;
  const osqueryAvailable = osquery === null || osquery === void 0 ? void 0 : osquery.isOsqueryAvailable({
    agentId: osqueryAgentId
  });

  // alert action items
  const alertsActionItems = (0, _react.useMemo)(() => !isEvent && alertSummaryData.ruleId ? [...statusActionItems, ...alertTagsItems, ...alertAssigneesItems, ...exceptionActionItems] : isEndpointEvent && canCreateEndpointEventFilters ? eventFilterActionItems : [], [eventFilterActionItems, isEndpointEvent, canCreateEndpointEventFilters, exceptionActionItems, statusActionItems, isEvent, alertSummaryData.ruleId, alertTagsItems, alertAssigneesItems]);
  const {
    addToCaseActionItems
  } = (0, _use_add_to_case_actions.useAddToCaseActions)({
    ecsData: dataAsNestedObject,
    nonEcsData: (_dataFormattedForFiel = dataFormattedForFieldBrowser === null || dataFormattedForFieldBrowser === void 0 ? void 0 : dataFormattedForFieldBrowser.map(d => ({
      field: d.field,
      value: d.values
    }))) !== null && _dataFormattedForFiel !== void 0 ? _dataFormattedForFiel : [],
    onMenuItemClick,
    onSuccess: refetchFlyoutData,
    refetch
  });

  // responder action items
  const endpointResponseActionsConsoleItems = (0, _responder.useResponderActionItem)(dataFormattedForFieldBrowser, closePopoverHandler);

  // items to render in the dropdown
  const items = (0, _react.useMemo)(() => [...addToCaseActionItems, ...alertsActionItems, ...hostIsolationActionItems, ...endpointResponseActionsConsoleItems, ...(osqueryAvailable ? [osqueryActionItem] : []), ...investigateInTimelineActionItems], [addToCaseActionItems, alertsActionItems, hostIsolationActionItems, endpointResponseActionsConsoleItems, osqueryAvailable, osqueryActionItem, investigateInTimelineActionItems]);

  // panels rendered in the context menu
  const panels = [{
    id: 0,
    items
  }, ...alertTagsPanels, ...alertAssigneesPanels, ...statusActionPanels];
  const takeActionButton = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": _test_ids.FLYOUT_FOOTER_DROPDOWN_BUTTON_TEST_ID,
    fill: true,
    iconSide: "right",
    iconType: "arrowDown",
    onClick: togglePopoverHandler,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 355,
      columnNumber: 9
    }
  }, TAKE_ACTION), [togglePopoverHandler]);
  return items.length && dataAsNestedObject ? /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "AlertTakeActionPanel",
    button: takeActionButton,
    isOpen: isPopoverOpen,
    closePopover: closePopoverHandler,
    panelPaddingSize: "none",
    anchorPosition: "downLeft",
    repositionOnScroll: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 370,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    size: "s",
    initialPanelId: 0,
    panels: panels,
    "data-test-subj": "takeActionPanelMenu",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 379,
      columnNumber: 9
    }
  })) : null;
});
TakeActionDropdown.displayName = 'TakeActionDropdown';