"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ThreatIntelligenceOverview = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _expandable_panel = require("../../../shared/components/expandable_panel");
var _use_fetch_threat_intelligence = require("../hooks/use_fetch_threat_intelligence");
var _insights_summary_row = require("./insights_summary_row");
var _context = require("../../shared/context");
var _test_ids = require("./test_ids");
var _left = require("../../left");
var _threat_intelligence_details = require("../../left/components/threat_intelligence_details");
var _use_navigate_to_left_panel = require("../../shared/hooks/use_navigate_to_left_panel");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/document_details/right/components/threat_intelligence_overview.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TITLE = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.securitySolution.flyout.right.insights.threatIntelligence.threatIntelligenceTitle",
  defaultMessage: "Threat intelligence",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 26,
    columnNumber: 3
  }
});
const TOOLTIP = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.securitySolution.flyout.right.insights.threatIntelligence.threatIntelligenceTooltip",
  defaultMessage: "Show all threat intelligence",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 32,
    columnNumber: 3
  }
});

/**
 * Threat intelligence section under Insights section, overview tab.
 * The component fetches the necessary data, then pass it down to the InsightsSubSection component for loading and error state,
 * and the SummaryPanel component for data rendering.
 */
const ThreatIntelligenceOverview = () => {
  const {
    dataFormattedForFieldBrowser,
    isPreviewMode
  } = (0, _context.useDocumentDetailsContext)();
  const {
    navigateToLeftPanel: goToThreatIntelligenceTab,
    isEnabled: isLinkEnabled
  } = (0, _use_navigate_to_left_panel.useNavigateToLeftPanel)({
    tab: _left.LeftPanelInsightsTab,
    subTab: _threat_intelligence_details.THREAT_INTELLIGENCE_TAB_ID
  });
  const {
    loading,
    threatMatchesCount,
    threatEnrichmentsCount
  } = (0, _use_fetch_threat_intelligence.useFetchThreatIntelligence)({
    dataFormattedForFieldBrowser
  });
  const link = (0, _react.useMemo)(() => isLinkEnabled ? {
    callback: goToThreatIntelligenceTab,
    tooltip: TOOLTIP
  } : undefined, [goToThreatIntelligenceTab, isLinkEnabled]);
  const threatMatchCountText = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.right.insights.threatIntelligence.threatMatchDescription",
    defaultMessage: "Threat {count, plural, one {match} other {matches}} detected",
    values: {
      count: threatMatchesCount
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 7
    }
  }), [threatMatchesCount]);
  const threatEnrichmentsCountText = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.right.insights.threatIntelligence.threatEnrichmentDescription",
    defaultMessage: "{count, plural, one {Field} other {Fields}} enriched with threat intelligence",
    values: {
      count: threatEnrichmentsCount
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 7
    }
  }), [threatEnrichmentsCount]);
  return /*#__PURE__*/_react.default.createElement(_expandable_panel.ExpandablePanel, {
    header: {
      title: TITLE,
      link,
      iconType: !isPreviewMode ? 'arrowStart' : undefined
    },
    "data-test-subj": _test_ids.INSIGHTS_THREAT_INTELLIGENCE_TEST_ID,
    content: {
      loading
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    "data-test-subj": `${_test_ids.INSIGHTS_THREAT_INTELLIGENCE_TEST_ID}Container`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_insights_summary_row.InsightsSummaryRow, {
    text: threatMatchCountText,
    value: threatMatchesCount,
    expandedSubTab: _threat_intelligence_details.THREAT_INTELLIGENCE_TAB_ID,
    "data-test-subj": _test_ids.INSIGHTS_THREAT_INTELLIGENCE_THREAT_MATCHES_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_insights_summary_row.InsightsSummaryRow, {
    text: threatEnrichmentsCountText,
    value: threatEnrichmentsCount,
    expandedSubTab: _threat_intelligence_details.THREAT_INTELLIGENCE_TAB_ID,
    "data-test-subj": _test_ids.INSIGHTS_THREAT_INTELLIGENCE_ENRICHED_WITH_THREAT_INTELLIGENCE_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 9
    }
  })));
};
exports.ThreatIntelligenceOverview = ThreatIntelligenceOverview;
ThreatIntelligenceOverview.displayName = 'ThreatIntelligenceOverview';