"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertHeaderTitle = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _i18nReact = require("@kbn/i18n-react");
var _use_experimental_features = require("../../../../common/hooks/use_experimental_features");
var _notes = require("./notes");
var _use_rule_details_link = require("../../shared/hooks/use_rule_details_link");
var _status = require("./status");
var _severity = require("./severity");
var _risk_score = require("./risk_score");
var _use_refetch_by_scope = require("../hooks/use_refetch_by_scope");
var _use_basic_data_from_details_data = require("../../shared/hooks/use_basic_data_from_details_data");
var _context = require("../../shared/context");
var _formatted_date = require("../../../../common/components/formatted_date");
var _test_ids = require("./test_ids");
var _assignees = require("./assignees");
var _flyout_title = require("../../../shared/components/flyout_title");
var _utils = require("../../shared/utils");
var _alert_header_block = require("../../../shared/components/alert_header_block");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/document_details/right/components/alert_header_title.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// minWidth for each block, allows to switch for a 1 row 4 blocks to 2 rows with 2 block each
const blockStyles = {
  minWidth: 280
};

/**
 * Alert details flyout right section header
 */
const AlertHeaderTitle = exports.AlertHeaderTitle = /*#__PURE__*/(0, _react.memo)(() => {
  const {
    dataFormattedForFieldBrowser,
    eventId,
    scopeId,
    isRulePreview,
    refetchFlyoutData,
    getFieldsData
  } = (0, _context.useDocumentDetailsContext)();
  const securitySolutionNotesDisabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('securitySolutionNotesDisabled');
  const {
    ruleName,
    timestamp,
    ruleId
  } = (0, _use_basic_data_from_details_data.useBasicDataFromDetailsData)(dataFormattedForFieldBrowser);
  const title = (0, _react.useMemo)(() => (0, _utils.getAlertTitle)({
    ruleName
  }), [ruleName]);
  const href = (0, _use_rule_details_link.useRuleDetailsLink)({
    ruleId: !isRulePreview ? ruleId : null
  });
  const ruleTitle = (0, _react.useMemo)(() => href ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: href,
    target: "_blank",
    external: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_flyout_title.FlyoutTitle, {
    title: title,
    iconType: 'warning',
    isLink: true,
    "data-test-subj": _test_ids.FLYOUT_ALERT_HEADER_TITLE_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 11
    }
  })) : /*#__PURE__*/_react.default.createElement(_flyout_title.FlyoutTitle, {
    title: title,
    iconType: 'warning',
    "data-test-subj": _test_ids.FLYOUT_ALERT_HEADER_TITLE_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 9
    }
  }), [title, href]);
  const {
    refetch
  } = (0, _use_refetch_by_scope.useRefetchByScope)({
    scopeId
  });
  const alertAssignees = (0, _react.useMemo)(() => {
    var _ref;
    return (_ref = getFieldsData(_ruleDataUtils.ALERT_WORKFLOW_ASSIGNEE_IDS)) !== null && _ref !== void 0 ? _ref : [];
  }, [getFieldsData]);
  const onAssigneesUpdated = (0, _react.useCallback)(() => {
    refetch();
    refetchFlyoutData();
  }, [refetch, refetchFlyoutData]);
  const riskScore = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_alert_header_block.AlertHeaderBlock, {
    hasBorder: true,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.right.header.riskScoreTitle",
      defaultMessage: "Risk score",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 93,
        columnNumber: 11
      }
    }),
    "data-test-subj": _test_ids.RISK_SCORE_TITLE_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_risk_score.RiskScore, {
    getFieldsData: getFieldsData,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 9
    }
  })), [getFieldsData]);
  const assignees = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_alert_header_block.AlertHeaderBlock, {
    hasBorder: true,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.right.header.assignedTitle",
      defaultMessage: "Assignees",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 111,
        columnNumber: 11
      }
    }),
    "data-test-subj": _test_ids.ASSIGNEES_TITLE_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_assignees.Assignees, {
    eventId: eventId,
    assignedUserIds: alertAssignees,
    onAssigneesUpdated: onAssigneesUpdated,
    showAssignees: !isRulePreview,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 9
    }
  })), [alertAssignees, eventId, isRulePreview, onAssigneesUpdated]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_severity.DocumentSeverity, {
    getFieldsData: getFieldsData,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 7
    }
  }), timestamp && /*#__PURE__*/_react.default.createElement(_formatted_date.PreferenceFormattedDate, {
    value: new Date(timestamp),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 21
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 7
    }
  }), ruleTitle, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 7
    }
  }), securitySolutionNotesDisabled ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    responsive: false,
    wrap: true,
    "data-test-subj": _test_ids.ALERT_SUMMARY_PANEL_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_status.DocumentStatus, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 11
    }
  }, riskScore), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 11
    }
  }, assignees)) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    responsive: false,
    wrap: true,
    "data-test-subj": _test_ids.ALERT_SUMMARY_PANEL_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: blockStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_status.DocumentStatus, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 15
    }
  }, riskScore))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: blockStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 15
    }
  }, assignees), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_notes.Notes, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 17
    }
  }))))));
});
AlertHeaderTitle.displayName = 'AlertHeaderTitle';