"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSorting = exports.usePagination = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PAGE_SIZES = [5, 10, 20];
const initialPagination = {
  pageIndex: 0,
  pageSize: PAGE_SIZES[0]
};
const paginationReducer = (_state, action) => {
  return action;
};
const initialSorting = {
  sort: {
    field: '@timestamp',
    direction: 'desc'
  },
  enableAllColumns: true
};
const sortingReducer = (state, action) => {
  return {
    ...state,
    sort: action
  };
};

/**
 * useSorting exposes resusable sorting logic that can be used with eui tables
 */
const useSorting = () => {
  const [sorting, setSorting] = (0, _react.useReducer)(sortingReducer, initialSorting);
  const sortConfig = (0, _react.useMemo)(() => {
    return [{
      [sorting.sort.field]: sorting.sort.direction
    }];
  }, [sorting.sort.direction, sorting.sort.field]);
  return {
    sorting,
    setSorting,
    sortConfig
  };
};

/**
 * use pagination adds reusable logic that can be applied to
 * eui tables
 */
exports.useSorting = useSorting;
const usePagination = () => {
  const [pagination, setPagination] = (0, _react.useReducer)(paginationReducer, initialPagination);
  return (0, _react.useMemo)(() => ({
    pageSizeOptions: [...PAGE_SIZES],
    pagination,
    setPagination
  }), [pagination]);
};
exports.usePagination = usePagination;