"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HeaderTitle = exports.HEADER_TITLE_TEST_ID = exports.HEADER_SUMMARY_TEST_ID = exports.HEADER_SEVERITY_TITLE_TEST_ID = exports.HEADER_RISK_SCORE_TITLE_TEST_ID = exports.HEADER_INTEGRATION_TITLE_TEST_ID = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../detections/constants");
var _integration_icon = require("./integration_icon");
var _severity = require("../../document_details/right/components/severity");
var _use_basic_data_from_details_data = require("../../document_details/shared/hooks/use_basic_data_from_details_data");
var _flyout_title = require("../../shared/components/flyout_title");
var _formatted_date = require("../../../common/components/formatted_date");
var _utils = require("../../document_details/shared/utils");
var _risk_score = require("../../document_details/right/components/risk_score");
var _context = require("../context");
var _alert_header_block = require("../../shared/components/alert_header_block");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/ai_for_soc/components/header_title.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const HEADER_TITLE_TEST_ID = exports.HEADER_TITLE_TEST_ID = 'ai-for-soc-alert-flyout-header-title';
const HEADER_SUMMARY_TEST_ID = exports.HEADER_SUMMARY_TEST_ID = 'ai-for-soc-alert-flyout-header-summary';
const HEADER_SEVERITY_TITLE_TEST_ID = exports.HEADER_SEVERITY_TITLE_TEST_ID = 'ai-for-soc-alert-flyout-header-severity';
const HEADER_RISK_SCORE_TITLE_TEST_ID = exports.HEADER_RISK_SCORE_TITLE_TEST_ID = 'ai-for-soc-alert-flyout-header-risk-score';
const HEADER_INTEGRATION_TITLE_TEST_ID = exports.HEADER_INTEGRATION_TITLE_TEST_ID = 'ai-for-soc-alert-flyout-header-integration';

/**
 * Header data for the AI for SOC for the alert summary flyout
 */
const HeaderTitle = exports.HeaderTitle = /*#__PURE__*/(0, _react.memo)(() => {
  const {
    dataFormattedForFieldBrowser,
    getFieldsData
  } = (0, _context.useAIForSOCDetailsContext)();
  const {
    ruleName,
    timestamp
  } = (0, _use_basic_data_from_details_data.useBasicDataFromDetailsData)(dataFormattedForFieldBrowser);
  const integrationName = (0, _react.useMemo)(() => (0, _utils.getField)(getFieldsData(_constants.RELATED_INTEGRATION)) || '', [getFieldsData]);
  const title = (0, _react.useMemo)(() => (0, _utils.getAlertTitle)({
    ruleName
  }), [ruleName]);
  const date = (0, _react.useMemo)(() => new Date(timestamp), [timestamp]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, timestamp && /*#__PURE__*/_react.default.createElement(_formatted_date.PreferenceFormattedDate, {
    value: date,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 21
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_flyout_title.FlyoutTitle, {
    "data-test-subj": HEADER_TITLE_TEST_ID,
    title: title,
    iconType: 'warning',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    "data-test-subj": HEADER_SUMMARY_TEST_ID,
    hasBorder: true,
    hasShadow: false,
    paddingSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_alert_header_block.AlertHeaderBlock, {
    "data-test-subj": HEADER_SEVERITY_TITLE_TEST_ID,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.aiForSOC.header.severityTitle",
      defaultMessage: "Severity",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 17
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_severity.DocumentSeverity, {
    getFieldsData: getFieldsData,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_alert_header_block.AlertHeaderBlock, {
    "data-test-subj": HEADER_RISK_SCORE_TITLE_TEST_ID,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.aiForSOC.header.riskScoreTitle",
      defaultMessage: "Risk score",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 17
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_risk_score.RiskScore, {
    getFieldsData: getFieldsData,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_alert_header_block.AlertHeaderBlock, {
    "data-test-subj": HEADER_INTEGRATION_TITLE_TEST_ID,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.right.header.integrationTitle",
      defaultMessage: "Integration",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 87,
        columnNumber: 17
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_integration_icon.IntegrationIcon, {
    integrationName: integrationName,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 15
    }
  }))))));
});
HeaderTitle.displayName = 'HeaderTitle';