"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useNetworkTls = exports.ID = void 0;
var _react = require("react");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _use_selector = require("../../../../common/hooks/use_selector");
var _helpers = require("../../../../common/containers/helpers");
var _helpers2 = require("../../../components/paginated_table/helpers");
var _store = require("../../store");
var _network = require("../../../../../common/search_strategy/security_solution/network");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_search_strategy = require("../../../../common/containers/use_search_strategy");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ID = exports.ID = 'networkTlsQuery';
const useNetworkTls = ({
  endDate,
  filterQuery,
  flowTarget,
  id,
  indexNames,
  ip,
  skip,
  startDate,
  type
}) => {
  const getTlsSelector = (0, _react.useMemo)(() => _store.networkSelectors.tlsSelector(), []);
  const {
    activePage,
    limit,
    sort
  } = (0, _use_selector.useDeepEqualSelector)(state => getTlsSelector(state, type));
  const [networkTlsRequest, setNetworkTlsRequest] = (0, _react.useState)(null);
  const wrappedLoadMore = (0, _react.useCallback)(newActivePage => {
    setNetworkTlsRequest(prevRequest => {
      if (!prevRequest) {
        return prevRequest;
      }
      return {
        ...prevRequest,
        pagination: (0, _helpers2.generateTablePaginationOptions)(newActivePage, limit)
      };
    });
  }, [limit]);
  const {
    loading,
    result: response,
    search,
    refetch,
    inspect
  } = (0, _use_search_strategy.useSearchStrategy)({
    factoryQueryType: _network.NetworkQueries.tls,
    initialResult: {
      edges: [],
      totalCount: -1,
      pageInfo: {
        activePage: 0,
        fakeTotalCount: 0,
        showMorePagesIndicator: false
      }
    },
    errorMessage: i18n.FAIL_NETWORK_TLS,
    abort: skip
  });
  const networkTlsResponse = (0, _react.useMemo)(() => ({
    endDate,
    tls: response.edges,
    id,
    inspect,
    isInspected: false,
    loadPage: wrappedLoadMore,
    pageInfo: response.pageInfo,
    refetch,
    startDate,
    totalCount: response.totalCount
  }), [endDate, id, inspect, refetch, response.edges, response.pageInfo, response.totalCount, startDate, wrappedLoadMore]);
  (0, _react.useEffect)(() => {
    setNetworkTlsRequest(prevRequest => {
      const myRequest = {
        ...(prevRequest !== null && prevRequest !== void 0 ? prevRequest : {}),
        defaultIndex: indexNames,
        factoryQueryType: _network.NetworkQueries.tls,
        filterQuery: (0, _helpers.createFilter)(filterQuery),
        flowTarget,
        ip,
        pagination: (0, _helpers2.generateTablePaginationOptions)(activePage, limit),
        timerange: {
          interval: '12h',
          from: startDate,
          to: endDate
        },
        sort
      };
      if (!(0, _fastDeepEqual.default)(prevRequest, myRequest)) {
        return myRequest;
      }
      return prevRequest;
    });
  }, [activePage, indexNames, endDate, filterQuery, limit, startDate, sort, flowTarget, ip, id]);
  (0, _react.useEffect)(() => {
    if (!skip && networkTlsRequest) {
      search(networkTlsRequest);
    }
  }, [networkTlsRequest, search, skip]);
  return [loading, networkTlsResponse];
};
exports.useNetworkTls = useNetworkTls;