"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SessionsTabBody = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _types = require("../../../../app/types");
var _sessions_viewer = require("../../../../common/components/sessions_viewer");
var _utils = require("../../../../common/components/visualization_actions/utils");
var _use_license = require("../../../../common/hooks/use_license");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/explore/hosts/pages/navigation/sessions_tab_body.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SessionsTabBody = exports.SessionsTabBody = /*#__PURE__*/_react.default.memo(alertsProps => {
  const {
    pageFilters,
    filterQuery,
    ...rest
  } = alertsProps;
  const hostPageFilters = (0, _react.useMemo)(() => {
    const hostNameExistsFilter = (0, _utils.fieldNameExistsFilter)(_types.SecurityPageName.hosts);
    return pageFilters != null ? [...hostNameExistsFilter, ...pageFilters] : hostNameExistsFilter;
  }, [pageFilters]);
  const isEnterprisePlus = (0, _use_license.useLicense)().isEnterprise();
  return isEnterprisePlus ? /*#__PURE__*/_react.default.createElement(_sessions_viewer.SessionsView, (0, _extends2.default)({
    entityType: "sessions",
    tableId: _securitysolutionDataTable.TableId.hostsPageSessions
  }, rest, {
    pageFilters: hostPageFilters,
    filterQuery: filterQuery,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 25,
      columnNumber: 5
    }
  })) : null;
});
SessionsTabBody.displayName = 'SessionsTabBody';