"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatItemsComponent = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _stat_item_header = require("./stat_item_header");
var _use_toggle_status = require("./use_toggle_status");
var _utils = require("./utils");
var _metric_embeddable = require("./metric_embeddable");
var _visualization_embeddable = require("../../../common/components/visualization_actions/visualization_embeddable");
var _use_experimental_features = require("../../../common/hooks/use_experimental_features");
var _constants = require("../../../data_view_manager/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/explore/components/stat_items/stat_items.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StatItemsComponent = exports.StatItemsComponent = /*#__PURE__*/_react.default.memo(({
  statItems,
  from,
  id,
  to
}) => {
  const timerange = (0, _react.useMemo)(() => ({
    from,
    to
  }), [from, to]);
  const {
    key,
    description,
    enableAreaChart,
    enableBarChart,
    fields,
    getBarChartLensAttributes,
    getAreaChartLensAttributes
  } = statItems;
  const {
    isToggleExpanded,
    onToggle
  } = (0, _use_toggle_status.useToggleStatus)({
    id
  });
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  return /*#__PURE__*/_react.default.createElement(_utils.FlexItem, {
    grow: 1,
    "data-test-subj": key,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_stat_item_header.StatItemHeader, {
    onToggle: onToggle,
    isToggleExpanded: isToggleExpanded,
    description: description,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 9
    }
  }), isToggleExpanded && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_metric_embeddable.MetricEmbeddable, {
    fields: fields,
    id: id,
    timerange: timerange,
    inspectTitle: description,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 13
    }
  }), (enableAreaChart || enableBarChart) && /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 53
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 13
    }
  }, enableBarChart && /*#__PURE__*/_react.default.createElement(_utils.FlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_visualization_embeddable.VisualizationEmbeddable, {
    "data-test-subj": "embeddable-bar-chart",
    getLensAttributes: getBarChartLensAttributes,
    timerange: timerange,
    id: `${id}-bar-embeddable`,
    height: _utils.ChartHeight,
    inspectTitle: description,
    scopeId: newDataViewPickerEnabled ? _constants.DataViewManagerScopeName.explore : _constants.DataViewManagerScopeName.default,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 19
    }
  })), enableAreaChart && from != null && to != null && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_utils.FlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_visualization_embeddable.VisualizationEmbeddable, {
    "data-test-subj": "embeddable-area-chart",
    getLensAttributes: getAreaChartLensAttributes,
    timerange: timerange,
    id: `${id}-area-embeddable`,
    height: _utils.ChartHeight,
    inspectTitle: description,
    scopeId: newDataViewPickerEnabled ? _constants.DataViewManagerScopeName.explore : _constants.DataViewManagerScopeName.default,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 21
    }
  })))))));
});
StatItemsComponent.displayName = 'StatItemsComponent';