"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SeverityFilter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _multiselect_filter = require("../../../common/components/multiselect_filter");
var _utils = require("../../common/utils");
var _common = require("./common");
var _translations = require("../risk_score/translations");
var _kibana = require("../../../common/lib/kibana");
var _telemetry = require("../../../common/lib/telemetry");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/components/severity/severity_filter.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SeverityFilter = ({
  onSelect,
  selectedItems,
  riskEntity
}) => {
  const {
    telemetry
  } = (0, _kibana.useKibana)().services;
  const renderItem = (0, _react.useCallback)(severity => {
    return /*#__PURE__*/_react.default.createElement(_common.RiskScoreLevel, {
      "data-test-subj": `risk-filter-item-${severity}`,
      severity: severity,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 32,
        columnNumber: 12
      }
    });
  }, []);
  const updateSeverityFilter = (0, _react.useCallback)((newSelection, changedSeverity, changedStatus) => {
    if (changedStatus === 'on') {
      telemetry.reportEvent(_telemetry.EntityEventTypes.EntityRiskFiltered, {
        entity: riskEntity,
        selectedSeverity: changedSeverity
      });
    }
    onSelect(newSelection);
  }, [onSelect, riskEntity, telemetry]);
  return /*#__PURE__*/_react.default.createElement(_multiselect_filter.MultiselectFilter, {
    "data-test-subj": "risk-filter",
    title: (0, _translations.ENTITY_RISK_LEVEL)(riskEntity),
    items: _utils.SEVERITY_UI_SORT_ORDER,
    selectedItems: selectedItems,
    onSelectionChange: updateSeverityFilter,
    renderItem: renderItem,
    width: 150,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 5
    }
  });
};
exports.SeverityFilter = SeverityFilter;