"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KeyInsightsTile = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _Either = require("fp-ts/Either");
var _lens_attributes = require("./lens_attributes");
var _visualization_embeddable = require("../../../../../../common/components/visualization_actions/visualization_embeddable");
var _use_esql_global_filter = require("../../../../../../common/hooks/esql/use_esql_global_filter");
var _use_global_time = require("../../../../../../common/containers/use_global_time");
var _use_space_id = require("../../../../../../common/hooks/use_space_id");
var _use_visualization_response = require("../../../../../../common/components/visualization_actions/use_visualization_response");
var _types = require("../../../../../../common/components/visualization_actions/types");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/components/privileged_user_monitoring/components/key_insights_panel/common/key_insights_tile.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LENS_VISUALIZATION_HEIGHT = 140;
const KeyInsightsTile = ({
  title,
  label,
  getEsqlQuery,
  id,
  inspectTitle,
  spaceId: propSpaceId
}) => {
  const filterQuery = (0, _use_esql_global_filter.useEsqlGlobalFilterQuery)();
  const timerange = (0, _use_global_time.useGlobalTime)();
  const hookSpaceId = (0, _use_space_id.useSpaceId)();

  // Use prop spaceId if provided, otherwise use hook spaceId, fallback to 'default'
  const effectiveSpaceId = propSpaceId || hookSpaceId || 'default';
  const visualizationResponse = (0, _use_visualization_response.useVisualizationResponse)({
    visualizationId: id
  });

  // Track whether loading has started at least once
  const [hasStartedLoading, setHasStartedLoading] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    if ((visualizationResponse === null || visualizationResponse === void 0 ? void 0 : visualizationResponse.loading) === true) {
      setHasStartedLoading(true);
    }
  }, [visualizationResponse === null || visualizationResponse === void 0 ? void 0 : visualizationResponse.loading]);

  // Reset hasStartedLoading when any filter changes to allow fresh error detection
  (0, _react.useEffect)(() => {
    setHasStartedLoading(false);
  }, [timerange.from, timerange.to, filterQuery, effectiveSpaceId]);
  const esqlQuery = getEsqlQuery(effectiveSpaceId);

  // Only show error state if:
  // 1. Loading has started at least once (hasStartedLoading)
  // 2. Loading is now complete (loading === false)
  // 3. We have no tables (indicating an error)
  if ((0, _Either.isLeft)(esqlQuery) || hasStartedLoading && visualizationResponse && visualizationResponse.loading === false && !visualizationResponse.tables) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      justifyContent: "spaceBetween",
      style: {
        height: '100%'
      } // ensures it uses the full height so 'space-between' works
      ,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 86,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("h4", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 87,
        columnNumber: 13
      }
    }, title))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      style: {
        alignSelf: 'flex-end'
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 91,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center",
      responsive: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 93,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 94,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 95,
        columnNumber: 17
      }
    }, _i18n.i18n.translate('xpack.securitySolution.privilegedUserMonitoring.keyInsights.NA', {
      defaultMessage: 'N/A'
    })))))));
  }
  const lensAttributes = (0, _lens_attributes.createKeyInsightsPanelLensAttributes)({
    title,
    label,
    esqlQuery: esqlQuery.right,
    dataViewId: 'default-dataview',
    filterQuery
  });

  // If we reach here, either still loading or we have a valid response, so show the embeddable
  return /*#__PURE__*/_react.default.createElement(_visualization_embeddable.VisualizationEmbeddable, {
    applyGlobalQueriesAndFilters: true,
    applyPageAndTabsFilters: true,
    lensAttributes: lensAttributes,
    id: id,
    timerange: timerange,
    width: '100%',
    height: LENS_VISUALIZATION_HEIGHT,
    disableOnClickFilter: true,
    inspectTitle: inspectTitle,
    withActions: [_types.VisualizationContextMenuActions.inspect, _types.VisualizationContextMenuActions.addToNewCase, _types.VisualizationContextMenuActions.addToExistingCase, _types.VisualizationContextMenuActions.saveToLibrary
    // Excluding VisualizationContextMenuActions.openInLens
    ],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 5
    }
  });
};
exports.KeyInsightsTile = KeyInsightsTile;